/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Collections;
import java.util.LinkedList;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.FileRenameHistory;
import org.tmatesoft.hg.internal.FileRevisionHistoryChunk;
import org.tmatesoft.hg.internal.ReverseIterator;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class FileHistory {
    private LinkedList<FileRevisionHistoryChunk> fileCompleteHistory = new LinkedList();
    private final HgDataFile df;
    private final int csetTo;
    private final int csetFrom;

    public FileHistory(HgDataFile file, int fromChangeset, int toChangeset) {
        this.df = file;
        this.csetFrom = fromChangeset;
        this.csetTo = toChangeset;
    }

    public int getStartChangeset() {
        return this.csetFrom;
    }

    public int getEndChangeset() {
        return this.csetTo;
    }

    public void build() throws HgRuntimeException {
        this.fileCompleteHistory.clear();
        Nodeid fileRev = this.df.getRepo().getManifest().getFileRevision(this.csetTo, this.df.getPath());
        int fileRevIndex = this.df.getRevisionIndex(fileRev);
        FileRenameHistory frh = new FileRenameHistory(this.csetFrom, this.csetTo);
        if (frh.isOutOfRange(this.df, fileRevIndex)) {
            return;
        }
        frh.build(this.df, fileRevIndex);
        FileRevisionHistoryChunk prevChunk = null;
        for (FileRenameHistory.Chunk c : frh.iterate(HgIterateDirection.OldToNew)) {
            FileRevisionHistoryChunk fileHistory = new FileRevisionHistoryChunk(c.file(), c.firstCset(), c.lastCset(), c.firstFileRev(), c.lastFileRev());
            fileHistory.init();
            if (fileHistory.revisionCount() == 0) continue;
            if (prevChunk != null) {
                prevChunk.linkTo(fileHistory);
            }
            this.fileCompleteHistory.addLast(fileHistory);
            prevChunk = fileHistory;
        }
    }

    public Iterable<FileRevisionHistoryChunk> iterate(HgIterateDirection order) {
        if (order == HgIterateDirection.NewToOld) {
            return ReverseIterator.reversed(this.fileCompleteHistory);
        }
        return Collections.unmodifiableList(this.fileCompleteHistory);
    }
}

