/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.internal.ReverseIterator;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;

public final class FileRenameHistory {
    private final int csetFrom;
    private final int csetTo;
    private final List<Chunk> history;

    public FileRenameHistory(int csetStartIndex, int csetEndIndex) {
        this.csetFrom = csetStartIndex;
        this.csetTo = csetEndIndex;
        this.history = new ArrayList<Chunk>(3);
    }

    public int startChangeset() {
        return this.csetFrom;
    }

    public int endChangeset() {
        return this.csetTo;
    }

    public boolean isOutOfRange(HgDataFile df, int fileRev) {
        return df.getChangesetRevisionIndex(fileRev) < this.csetFrom || df.getChangesetRevisionIndex(0) > this.csetTo;
    }

    public void build(HgDataFile df, int fileRev) {
        assert (!this.isOutOfRange(df, fileRev));
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        int chunkStart = 0;
        int chunkEnd = fileRev;
        int csetChunkEnd = -1;
        int csetChunkStart = -1;
        BasicRevMap csetMap = new BasicRevMap(0, fileRev).collect(df);
        while (fileRev >= 0) {
            int cset = csetMap.changesetAt(fileRev);
            if (csetChunkEnd == -1) {
                csetChunkEnd = cset;
            }
            if (cset <= this.csetFrom) {
                chunkStart = fileRev;
                csetChunkStart = this.csetFrom;
                break;
            }
            if (cset > this.csetTo) {
                chunkEnd = --fileRev;
                csetChunkEnd = -1;
                continue;
            }
            csetChunkStart = cset;
            if (df.isCopy(fileRev)) {
                chunks.addFirst(new Chunk(df, fileRev, chunkEnd, csetChunkStart, csetChunkEnd));
                HgFileRevision origin = df.getCopySource(fileRev);
                df = df.getRepo().getFileNode(origin.getPath());
                fileRev = chunkEnd = df.getRevisionIndex(origin.getRevision());
                csetMap = new BasicRevMap(0, fileRev).collect(df);
                chunkStart = 0;
                csetChunkEnd = cset - 1;
                csetChunkStart = -1;
                continue;
            }
            --fileRev;
        }
        assert (chunkStart >= 0);
        assert (chunkEnd >= 0);
        assert (csetChunkEnd >= 0);
        assert (csetChunkStart >= 0);
        chunks.addFirst(new Chunk(df, chunkStart, chunkEnd, csetChunkStart, csetChunkEnd));
        this.history.clear();
        this.history.addAll(chunks);
    }

    public Iterable<Chunk> iterate(HgIterateDirection order) {
        if (order == HgIterateDirection.NewToOld) {
            return ReverseIterator.reversed(this.history);
        }
        assert (order == HgIterateDirection.OldToNew);
        return Collections.unmodifiableList(this.history);
    }

    public int chunks() {
        return this.history.size();
    }

    public Chunk chunkAt(int cset) {
        if (cset < this.csetFrom || cset > this.csetTo) {
            return null;
        }
        for (Chunk c : this.history) {
            if (c.firstCset() > cset) break;
            if (cset > c.lastCset()) continue;
            return c;
        }
        return null;
    }

    private static final class BasicRevMap
    implements Revlog.LinkRevisionInspector {
        private final int[] revs;
        private final int fromRev;
        private final int toRev;

        public BasicRevMap(int startRev, int endRev) {
            this.revs = new int[endRev + 1];
            this.fromRev = startRev;
            this.toRev = endRev;
            Arrays.fill(this.revs, Integer.MIN_VALUE);
        }

        public BasicRevMap collect(HgDataFile df) {
            df.indexWalk(this.fromRev, this.toRev, this);
            return this;
        }

        @Override
        public void next(int revisionIndex, int linkedRevisionIndex) throws HgRuntimeException {
            this.revs[revisionIndex] = linkedRevisionIndex;
        }

        public int changesetAt(int rev) {
            return this.revs[rev];
        }
    }

    public static final class Chunk {
        private final HgDataFile df;
        private final int fileRevFrom;
        private final int fileRevTo;
        private final int csetFrom;
        private final int csetTo;

        Chunk(HgDataFile file, int fileRevStart, int fileRevEnd, int csetStart, int csetEnd) {
            this.df = file;
            this.fileRevFrom = fileRevStart;
            this.fileRevTo = fileRevEnd;
            this.csetFrom = csetStart;
            this.csetTo = csetEnd;
        }

        public HgDataFile file() {
            return this.df;
        }

        public int firstFileRev() {
            return this.fileRevFrom;
        }

        public int lastFileRev() {
            return this.fileRevTo;
        }

        public int firstCset() {
            return this.csetFrom;
        }

        public int lastCset() {
            return this.csetTo;
        }
    }
}

