/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgRuntimeException;

public final class FileRevisionHistoryChunk {
    private final HgDataFile df;
    private IntVector fileRevsToVisit;
    private IntVector fileParentRevs;
    private int[] file2changelog;
    private int originChangelogRev = Integer.MIN_VALUE;
    private int originFileRev = Integer.MIN_VALUE;
    private final int csetFrom;
    private final int csetTo;
    private final int fileRevFrom;
    private final int fileRevTo;

    public FileRevisionHistoryChunk(HgDataFile file, int csetStart, int csetEnd, int fileStart, int fileEnd) {
        assert (fileEnd >= fileStart);
        this.df = file;
        this.csetFrom = csetStart;
        this.csetTo = csetEnd;
        this.fileRevFrom = fileStart;
        this.fileRevTo = fileEnd;
    }

    public HgDataFile getFile() {
        return this.df;
    }

    public int getStartChangeset() {
        return this.csetFrom;
    }

    public int getEndChangeset() {
        return this.csetTo;
    }

    public void init() throws HgRuntimeException {
        int[] fileRevParents = new int[2];
        int totalFileRevs = this.fileRevTo - this.fileRevFrom + 1;
        this.fileParentRevs = new IntVector(totalFileRevs * 2, 0);
        this.fileParentRevs.add(-1, -1);
        int i = this.fileRevFrom + 1;
        while (i <= this.fileRevTo) {
            this.df.parents(i, fileRevParents, null, null);
            this.fileParentRevs.add(fileRevParents[0], fileRevParents[1]);
            ++i;
        }
        this.fileRevsToVisit = new IntVector(totalFileRevs, 0);
        this.file2changelog = new int[totalFileRevs];
        Arrays.fill(this.file2changelog, Integer.MIN_VALUE);
        LinkedList<Integer> queue = new LinkedList<Integer>();
        BitSet seen = new BitSet(totalFileRevs);
        queue.add(this.fileRevTo);
        do {
            int fileRev;
            int offFileRev;
            if (seen.get(offFileRev = (fileRev = ((Integer)queue.removeFirst()).intValue()) - this.fileRevFrom)) continue;
            seen.set(offFileRev);
            int csetRev = this.df.getChangesetRevisionIndex(fileRev);
            if (csetRev < this.csetFrom || csetRev > this.csetTo) continue;
            this.fileRevsToVisit.add(fileRev);
            this.file2changelog[offFileRev] = csetRev;
            int p1 = this.fileParentRevs.get(2 * offFileRev);
            int p2 = this.fileParentRevs.get(2 * offFileRev + 1);
            if (p1 != -1 && p1 >= this.fileRevFrom) {
                queue.addLast(p1);
            }
            if (p2 == -1 || p2 < this.fileRevFrom) continue;
            queue.addLast(p2);
        } while (!queue.isEmpty());
        this.fileRevsToVisit.sort(false);
    }

    public void linkTo(FileRevisionHistoryChunk next) {
        if (next == null) {
            return;
        }
        next.originFileRev = this.fileRevsToVisit.get(0);
        next.originChangelogRev = this.changeset(next.originFileRev);
    }

    public int[] fileRevisions(HgIterateDirection iterateOrder) {
        int[] rv = this.fileRevsToVisit.toArray();
        if (iterateOrder == HgIterateDirection.OldToNew) {
            int a = 0;
            int b = rv.length - 1;
            while (a < b) {
                int t = rv[b];
                rv[b] = rv[a];
                rv[a] = t;
                ++a;
                --b;
            }
        }
        return rv;
    }

    public int revisionCount() {
        return this.fileRevsToVisit.size();
    }

    public int changeset(int fileRevIndex) {
        return this.file2changelog[fileRevIndex - this.fileRevFrom];
    }

    public void fillFileParents(int fileRevIndex, int[] fileParents) {
        if (fileRevIndex == this.fileRevFrom && this.originFileRev != Integer.MIN_VALUE) {
            assert (this.originFileRev != -1);
            fileParents[0] = this.originFileRev;
            fileParents[1] = -1;
            return;
        }
        int x = fileRevIndex - this.fileRevFrom;
        fileParents[0] = this.fileParentRevs.get(x * 2);
        fileParents[1] = this.fileParentRevs.get(x * 2 + 1);
    }

    public void fillCsetParents(int fileRevIndex, int[] csetParents) {
        if (fileRevIndex == this.fileRevFrom && this.originFileRev != Integer.MIN_VALUE) {
            assert (this.originChangelogRev != -1);
            csetParents[0] = this.originChangelogRev;
            csetParents[1] = -1;
            return;
        }
        int x = fileRevIndex - this.fileRevFrom;
        int fp1 = this.fileParentRevs.get(x * 2);
        int fp2 = this.fileParentRevs.get(x * 2 + 1);
        csetParents[0] = fp1 == -1 ? -1 : this.changeset(fp1);
        csetParents[1] = fp2 == -1 ? -1 : this.changeset(fp2);
    }
}

