/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.ProcessExecHelper;
import org.tmatesoft.hg.util.LogFacility;

public class FileSystemHelper {
    private final SessionContext ctx;
    private final List<String> linkCmd;
    private final List<String> chmodCmd;
    private final List<String> statCmd;
    private final ProcessExecHelper execHelper;

    public FileSystemHelper(SessionContext sessionContext) {
        this.ctx = sessionContext;
        if (Internals.runningOnWindows()) {
            this.linkCmd = Arrays.asList("mklink", "%1", "%2");
            this.chmodCmd = Collections.emptyList();
            this.statCmd = Collections.emptyList();
        } else {
            this.linkCmd = Arrays.asList("/bin/ln", "-s", "%2", "%1");
            this.chmodCmd = Arrays.asList("/bin/chmod", "+x", "%1");
            this.statCmd = Arrays.asList("stat", "--format=%a", "%1");
        }
        this.execHelper = new ProcessExecHelper();
    }

    public void createSymlink(File parentDir, String linkName, byte[] target) throws IOException {
        ArrayList<String> command = new ArrayList<String>(this.linkCmd);
        command.set(command.indexOf("%1"), linkName);
        String targetFilename = Internals.getFileEncoding(this.ctx).decode(ByteBuffer.wrap(target)).toString();
        command.set(command.indexOf("%2"), targetFilename);
        this.execHelper.cwd(parentDir);
        try {
            this.execHelper.exec(command);
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ex.initCause(ex);
            throw e;
        }
    }

    public void setExecutableBit(File parentDir, String fname) throws IOException {
        if (this.chmodCmd.isEmpty()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>(this.chmodCmd);
        command.set(command.indexOf("%1"), fname);
        this.execHelper.cwd(parentDir);
        try {
            this.execHelper.exec(command);
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ex.initCause(ex);
            throw e;
        }
    }

    public int getFileMode(File file, int defaultValue) throws IOException {
        if (this.statCmd.isEmpty()) {
            return defaultValue;
        }
        ArrayList<String> command = new ArrayList<String>(this.statCmd);
        command.set(command.indexOf("%1"), file.getAbsolutePath());
        String result = null;
        try {
            result = this.execHelper.exec(command).toString().trim();
            if (result.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(result, 8);
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ex.initCause(ex);
            throw e;
        }
        catch (NumberFormatException ex) {
            this.ctx.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, String.format("Bad value for access rights:%s", result));
            return defaultValue;
        }
    }
}

