/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.StreamLogFacility;
import org.tmatesoft.hg.util.LogFacility;

public final class FileUtils {
    private final LogFacility log;
    private final Class<?> troublemaker;

    public static void copyFile(File from, File to) throws HgIOException {
        new FileUtils(new StreamLogFacility(LogFacility.Severity.Debug, true, System.err), FileUtils.class).copy(from, to);
    }

    public FileUtils(LogFacility logFacility, Object troubleSource) {
        this.log = logFacility;
        this.troublemaker = troubleSource == null ? null : (troubleSource instanceof Class ? (Class<?>)troubleSource : troubleSource.getClass());
    }

    public void copy(File from, File to) throws HgIOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            FileChannel input = fis.getChannel();
            FileChannel output = fos.getChannel();
            long count = input.size();
            long pos = 0L;
            int zeroCopied = 0;
            do {
                long c = input.transferTo(pos, count, output);
                pos += c;
                count -= c;
                if (c == 0L) {
                    if (++zeroCopied != 3) continue;
                    String m = String.format("Can't copy %s to %s, transferTo copies 0 bytes. Position: %d, bytes left:%d", from.getName(), to.getName(), pos, count);
                    throw new IOException(m);
                }
                zeroCopied = 0;
            } while (count > 0L);
            fos.close();
            fos = null;
            fis.close();
            fis = null;
        }
        catch (IOException ex) {
            this.closeQuietly(fis, from);
            this.closeQuietly(fos, to);
            String m = String.format("Failed to copy %s to %s", from.getName(), to.getName());
            throw new HgIOException(m, ex, from);
        }
    }

    public void write(InputStream is, File file) throws IOException {
        int r;
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[8192];
        while ((r = is.read(buf)) != -1) {
            fos.write(buf, 0, r);
        }
        fos.flush();
        fos.close();
    }

    public void closeQuietly(Closeable stream) {
        this.closeQuietly(stream, null);
    }

    public void closeQuietly(Closeable stream, File f) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                String msg = f == null ? "Exception while closing stream quietly" : String.format("Failed to close %s", f);
                this.log.dump(this.troublemaker == null ? this.getClass() : this.troublemaker, LogFacility.Severity.Warn, ex, msg);
            }
        }
    }
}

