/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.hg.internal.Filter;
import org.tmatesoft.hg.internal.Preview;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelledException;

public class FilterByteChannel
implements ByteChannel,
Adaptable {
    private final Filter[] filters;
    private final ByteChannel delegate;

    public FilterByteChannel(ByteChannel delegateChannel, Collection<Filter> filtersToApply) {
        if (delegateChannel == null || filtersToApply == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegateChannel;
        this.filters = filtersToApply.toArray(new Filter[filtersToApply.size()]);
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException, CancelledException {
        int srcPos = buffer.position();
        ByteBuffer processed = buffer;
        Filter[] filterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter f = filterArray[n2];
            processed = f.filter(processed);
            ++n2;
        }
        this.delegate.write(processed);
        return buffer.position() - srcPos;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        if (adapterClass == Preview.class) {
            ArrayList<Preview> previewers = new ArrayList<Preview>(this.filters.length);
            Adaptable.Factory<Preview> factory = new Adaptable.Factory<Preview>(Preview.class);
            Filter[] filterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                Filter f = filterArray[n2];
                Preview p = factory.get(f);
                if (p != null) {
                    previewers.add(p);
                }
                ++n2;
            }
            if (!previewers.isEmpty()) {
                PreviewSupport rv = new PreviewSupport(previewers);
                return (T)rv;
            }
        }
        return Adaptable.Factory.getAdapter(this.delegate, adapterClass, null);
    }

    private static class PreviewSupport
    implements Preview {
        private final Preview[] participants;

        public PreviewSupport(List<Preview> previewers) {
            this.participants = new Preview[previewers.size()];
            previewers.toArray(this.participants);
        }

        @Override
        public void preview(ByteBuffer src) {
            int originalPos = src.position();
            Preview[] previewArray = this.participants;
            int n = this.participants.length;
            int n2 = 0;
            while (n2 < n) {
                Preview p = previewArray[n2];
                p.preview(src);
                src.position(originalPos);
                ++n2;
            }
        }
    }
}

