/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import org.tmatesoft.hg.internal.DataAccess;

public class FilterDataAccess
extends DataAccess {
    private final DataAccess dataAccess;
    private final long offset;
    private final int length;
    private int count;

    public FilterDataAccess(DataAccess dataAccess, long offset, int length) {
        this.dataAccess = dataAccess;
        this.offset = offset;
        this.length = length;
        this.count = length;
    }

    protected int available() throws IOException {
        return this.count;
    }

    @Override
    public FilterDataAccess reset() throws IOException {
        this.dataAccess.reset();
        this.count = this.length;
        return this;
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.count <= 0;
    }

    @Override
    public int length() throws IOException {
        return this.length;
    }

    @Override
    public void seek(int localOffset) throws IOException {
        if (localOffset < 0 || localOffset > this.length) {
            throw new IllegalArgumentException();
        }
        this.dataAccess.longSeek(this.offset + (long)localOffset);
        this.count = this.length - localOffset;
    }

    @Override
    public void skip(int bytes) throws IOException {
        int newCount = this.count - bytes;
        if (newCount < 0 || newCount > this.length) {
            throw new IllegalArgumentException();
        }
        this.seek(this.length - newCount);
    }

    @Override
    public byte readByte() throws IOException {
        if (this.count <= 0) {
            throw new IOException(String.format("Underflow. Bytes left: %d. FilterDA[offset: %d, length: %d]", this.count, this.offset, this.length));
        }
        if (this.count == this.length) {
            this.dataAccess.longSeek(this.offset);
        }
        --this.count;
        return this.dataAccess.readByte();
    }

    @Override
    public void readBytes(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.count <= 0 || len > this.count) {
            throw new IOException(String.format("Underflow. Bytes left: %d, asked to read %d. FilterDA[offset: %d, length: %d]", this.count, len, this.offset, this.length));
        }
        if (this.count == this.length) {
            this.dataAccess.longSeek(this.offset);
        }
        this.dataAccess.readBytes(b, off, len);
        this.count -= len;
    }
}

