/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.core.HgAnnotateCommand;
import org.tmatesoft.hg.core.HgBlameInspector;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.IntSliceSeq;
import org.tmatesoft.hg.internal.IntTuple;
import org.tmatesoft.hg.internal.LineImpl;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class ForwardAnnotateInspector
implements HgBlameInspector,
HgBlameInspector.RevisionDescriptor.Recipient {
    final IntMap<IntSliceSeq> all = new IntMap(100);
    private final IntMap<IntMap<byte[]>> lineContent = new IntMap(100);
    private IntSliceSeq current;
    private HgBlameInspector.RevisionDescriptor revDescriptor;

    public HgIterateDirection iterateDirection() {
        return HgIterateDirection.OldToNew;
    }

    public void report(int revision, HgAnnotateCommand.Inspector insp, ProgressSupport progress, CancelSupport cancel) throws HgCallbackTargetException, CancelledException {
        int totalLines = 0;
        if (!this.all.containsKey(revision)) {
            throw new IllegalArgumentException(String.format("Revision %d has not been visited", revision));
        }
        for (IntTuple t : this.all.get(revision)) {
            totalLines += t.at(0);
        }
        progress.start(totalLines);
        LineImpl li = new LineImpl();
        int line = 1;
        for (IntTuple t : this.all.get(revision)) {
            IntMap<byte[]> revLines = this.lineContent.get(t.at(1));
            int i = 0;
            int x = t.at(0);
            while (i < x) {
                int lineInRev = t.at(2) + i;
                byte[] lc = revLines.get(lineInRev);
                li.init(line++, lineInRev + 1, t.at(1), lc);
                insp.next(li);
                progress.worked(1);
                cancel.checkCancelled();
                ++i;
            }
        }
        progress.done();
    }

    @Override
    public void start(HgBlameInspector.RevisionDescriptor rd) throws HgCallbackTargetException {
        this.current = new IntSliceSeq(3);
        this.all.put(rd.targetChangesetIndex(), this.current);
        this.revDescriptor = rd;
    }

    @Override
    public void done(HgBlameInspector.RevisionDescriptor rd) throws HgCallbackTargetException {
        this.revDescriptor = null;
    }

    @Override
    public void same(HgBlameInspector.EqualBlock block) throws HgCallbackTargetException {
        this.copyBlock(block.originChangesetIndex(), block.originStart(), block.length());
    }

    @Override
    public void added(HgBlameInspector.AddBlock block) throws HgCallbackTargetException {
        if (this.revDescriptor.isMerge() && block.originChangesetIndex() == this.revDescriptor.mergeChangesetIndex()) {
            this.copyBlock(block.originChangesetIndex(), block.insertedAt(), block.totalAddedLines());
            return;
        }
        HgBlameInspector.BlockData addedLines = block.addedLines();
        IntMap<Object> revLines = this.lineContent.get(block.targetChangesetIndex());
        if (revLines == null) {
            revLines = new IntMap(block.totalAddedLines());
            this.lineContent.put(block.targetChangesetIndex(), revLines);
        }
        int i = 0;
        while (i < block.totalAddedLines()) {
            revLines.put(block.firstAddedLine() + i, addedLines.elementAt(i).asArray());
            ++i;
        }
        this.current.add(block.totalAddedLines(), block.targetChangesetIndex(), block.firstAddedLine());
    }

    @Override
    public void changed(HgBlameInspector.ChangeBlock block) throws HgCallbackTargetException {
        this.added(block);
    }

    @Override
    public void deleted(HgBlameInspector.DeleteBlock block) throws HgCallbackTargetException {
    }

    private void copyBlock(int originChangesetIndex, int blockStart, int length) {
        IntSliceSeq origin = this.all.get(originChangesetIndex);
        assert (origin != null);
        int originPos = 0;
        int targetBlockLen = length;
        for (IntTuple t : origin) {
            int originBlockLen = t.at(0);
            int originBlockEnd = originPos + originBlockLen;
            if (originBlockEnd > blockStart) {
                int originBlockOverlap = Math.min(originBlockLen, originBlockEnd - blockStart);
                assert (originBlockOverlap > 0);
                int originBlockConsumed = Math.min(originBlockOverlap, targetBlockLen);
                int originBlockLine = t.at(2);
                if (originPos < blockStart) {
                    originBlockLine += originBlockLen - originBlockOverlap;
                }
                this.current.add(originBlockConsumed, t.at(1), originBlockLine);
                if ((targetBlockLen -= originBlockConsumed) == 0) break;
            }
            originPos += originBlockLen;
        }
    }
}

