/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.internal.DiffHelper;
import org.tmatesoft.hg.internal.Patch;

class GeneratePatchInspector
extends DiffHelper.DeltaInspector<DiffHelper.LineSequence> {
    private final Patch deltaCollector;

    GeneratePatchInspector(Patch p) {
        assert (p != null);
        this.deltaCollector = p;
    }

    public static Patch delta(byte[] prev, byte[] content) {
        Patch rv = new Patch();
        DiffHelper<DiffHelper.LineSequence> pg = new DiffHelper<DiffHelper.LineSequence>();
        pg.init(new DiffHelper.LineSequence(prev).splitByNewlines(), new DiffHelper.LineSequence(content).splitByNewlines());
        pg.findMatchingBlocks(new GeneratePatchInspector(rv));
        return rv;
    }

    @Override
    protected void changed(int s1From, int s1To, int s2From, int s2To) {
        int from = ((DiffHelper.LineSequence)this.seq1).chunk(s1From).getOffset();
        int to = ((DiffHelper.LineSequence)this.seq1).chunk(s1To).getOffset();
        byte[] data = ((DiffHelper.LineSequence)this.seq2).data(s2From, s2To);
        this.deltaCollector.add(from, to, data);
    }

    @Override
    protected void deleted(int s2DeletionPoint, int s1From, int s1To) {
        int from = ((DiffHelper.LineSequence)this.seq1).chunk(s1From).getOffset();
        int to = ((DiffHelper.LineSequence)this.seq1).chunk(s1To).getOffset();
        this.deltaCollector.add(from, to, new byte[0]);
    }

    @Override
    protected void added(int s1InsertPoint, int s2From, int s2To) {
        int insPoint = ((DiffHelper.LineSequence)this.seq1).chunk(s1InsertPoint).getOffset();
        byte[] data = ((DiffHelper.LineSequence)this.seq2).data(s2From, s2To);
        this.deltaCollector.add(insPoint, insPoint, data);
    }
}

