/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.FilterDataAccess;

public class InflaterDataAccess
extends FilterDataAccess {
    private final Inflater inflater;
    private final byte[] inBuffer;
    private final ByteBuffer outBuffer;
    private int inflaterPos = 0;
    private int decompressedLength;

    public InflaterDataAccess(DataAccess dataAccess, long offset, int compressedLength) {
        this(dataAccess, offset, compressedLength, -1, new Inflater(), new byte[512], null);
    }

    public InflaterDataAccess(DataAccess dataAccess, long offset, int compressedLength, int actualLength) {
        this(dataAccess, offset, compressedLength, actualLength, new Inflater(), new byte[512], null);
    }

    public InflaterDataAccess(DataAccess dataAccess, long offset, int compressedLength, int actualLength, Inflater inflater, byte[] inBuf, ByteBuffer outBuf) {
        super(dataAccess, offset, compressedLength);
        if (inflater == null || inBuf == null) {
            throw new IllegalArgumentException();
        }
        this.inflater = inflater;
        this.decompressedLength = actualLength;
        this.inBuffer = inBuf;
        this.outBuffer = outBuf == null ? ByteBuffer.allocate(this.inBuffer.length * 2) : outBuf;
        this.outBuffer.limit(0);
    }

    @Override
    public InflaterDataAccess reset() throws IOException {
        super.reset();
        this.inflater.reset();
        this.inflaterPos = 0;
        this.outBuffer.clear().limit(0);
        return this;
    }

    @Override
    protected int available() throws IOException {
        return this.length() - this.decompressedPosition();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.available() <= 0;
    }

    @Override
    public int length() throws IOException {
        int c;
        if (this.decompressedLength != -1) {
            return this.decompressedLength;
        }
        this.decompressedLength = 0;
        int oldPos = this.decompressedPosition();
        int inflatedUpTo = this.inflaterPos;
        int inflatedMore = 0;
        do {
            this.outBuffer.limit(this.outBuffer.position());
            c = this.fillOutBuffer();
            inflatedMore += c;
        } while (c == this.outBuffer.capacity());
        this.decompressedLength = inflatedUpTo + inflatedMore;
        this.reset();
        this.seek(oldPos);
        return this.decompressedLength;
    }

    @Override
    public void seek(int localOffset) throws IOException {
        if (localOffset < 0) {
            throw new IllegalArgumentException();
        }
        int currentPos = this.decompressedPosition();
        if (localOffset >= currentPos) {
            this.skip(localOffset - currentPos);
        } else {
            this.reset();
            this.skip(localOffset);
        }
    }

    @Override
    public void skip(int bytesToSkip) throws IOException {
        int bytes = bytesToSkip;
        if (bytes < 0) {
            if ((bytes += this.decompressedPosition()) < 0) {
                throw new IOException(String.format("Underflow. Rewind past start of the slice. To skip:%d, decPos:%d, decLen:%d. Left:%d", bytesToSkip, this.inflaterPos, this.decompressedLength, bytes));
            }
            this.reset();
        }
        while (!this.isEmpty() && bytes > 0) {
            int fromBuffer = this.outBuffer.remaining();
            if (fromBuffer > 0) {
                if (fromBuffer >= bytes) {
                    this.outBuffer.position(this.outBuffer.position() + bytes);
                    bytes = 0;
                    break;
                }
                bytes -= fromBuffer;
                this.outBuffer.limit(this.outBuffer.position());
            }
            this.fillOutBuffer();
        }
        if (bytes != 0) {
            throw new IOException(String.format("Underflow. Rewind past end of the slice. To skip:%d, decPos:%d, decLen:%d. Left:%d", bytesToSkip, this.inflaterPos, this.decompressedLength, bytes));
        }
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.outBuffer.hasRemaining()) {
            this.fillOutBuffer();
        }
        return this.outBuffer.get();
    }

    @Override
    public void readBytes(byte[] b, int off, int len) throws IOException {
        int fromBuffer;
        do {
            if ((fromBuffer = this.outBuffer.remaining()) > 0) {
                if (fromBuffer >= len) {
                    this.outBuffer.get(b, off, len);
                    return;
                }
                this.outBuffer.get(b, off, fromBuffer);
                off += fromBuffer;
                len -= fromBuffer;
            }
            fromBuffer = this.fillOutBuffer();
        } while (len > 0 && fromBuffer > 0);
        if (len > 0) {
            throw new EOFException(String.format("No more compressed data is available to satisfy request for %d bytes. [finished:%b, needDict:%b, needInp:%b, available:%d", len, this.inflater.finished(), this.inflater.needsDictionary(), this.inflater.needsInput(), super.available()));
        }
    }

    @Override
    public void readBytes(ByteBuffer buf) throws IOException {
        int len = Math.min(this.available(), buf.remaining());
        while (len > 0) {
            if (this.outBuffer.remaining() >= len) {
                ByteBuffer slice = this.outBuffer.slice();
                slice.limit(len);
                buf.put(slice);
                this.outBuffer.position(this.outBuffer.position() + len);
                return;
            }
            len -= this.outBuffer.remaining();
            buf.put(this.outBuffer);
            this.fillOutBuffer();
        }
    }

    private int decompressedPosition() {
        assert (this.outBuffer.remaining() <= this.inflaterPos);
        return this.inflaterPos - this.outBuffer.remaining();
    }

    private int fillOutBuffer() throws IOException {
        assert (!this.outBuffer.hasRemaining());
        try {
            int inflatedBytes = 0;
            this.outBuffer.clear();
            int len = this.outBuffer.capacity();
            int off = 0;
            while (true) {
                int n;
                if ((n = this.inflater.inflate(this.outBuffer.array(), off, len)) == 0) {
                    int toRead = -1;
                    if (this.inflater.needsInput() && (toRead = super.available()) > 0) {
                        if (toRead > this.inBuffer.length) {
                            toRead = this.inBuffer.length;
                        }
                        super.readBytes(this.inBuffer, 0, toRead);
                        this.inflater.setInput(this.inBuffer, 0, toRead);
                        continue;
                    }
                    assert (this.inflater.finished());
                    assert (toRead <= 0);
                }
                off += n;
                inflatedBytes += n;
                if ((len -= n) <= 0 || this.inflater.finished()) break;
            }
            this.inflaterPos += inflatedBytes;
            this.outBuffer.limit(inflatedBytes);
            assert (this.outBuffer.position() == 0);
            return inflatedBytes;
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw new ZipException(s != null ? s : "Invalid ZLIB data format");
        }
    }
}

