/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class IntMap<V> {
    private int[] keys;
    private Object[] values;
    private int size;

    public IntMap(int size) {
        this.keys = new int[size <= 0 ? 16 : size];
        this.values = new Object[this.keys.length];
    }

    public int size() {
        return this.size;
    }

    public int firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.keys[0];
    }

    public int lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.keys[this.size - 1];
    }

    public void trimToSize() {
        if (this.size < this.keys.length) {
            int[] newKeys = new int[this.size];
            Object[] newValues = new Object[this.size];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.keys = newKeys;
            this.values = newValues;
        }
    }

    public void put(int key, V value) {
        int ix = IntMap.binarySearch(this.keys, this.size, key);
        if (ix < 0) {
            int insertPoint = -ix - 1;
            assert (insertPoint <= this.size);
            if (this.size == this.keys.length) {
                int capInc = this.size >>> 2;
                int newCapacity = this.size + (capInc < 2 ? 2 : capInc);
                int[] newKeys = new int[newCapacity];
                Object[] newValues = new Object[newCapacity];
                System.arraycopy(this.keys, 0, newKeys, 0, insertPoint);
                System.arraycopy(this.keys, insertPoint, newKeys, insertPoint + 1, this.keys.length - insertPoint);
                System.arraycopy(this.values, 0, newValues, 0, insertPoint);
                System.arraycopy(this.values, insertPoint, newValues, insertPoint + 1, this.values.length - insertPoint);
                this.keys = newKeys;
                this.values = newValues;
            } else if (insertPoint != this.size) {
                System.arraycopy(this.keys, insertPoint, this.keys, insertPoint + 1, this.keys.length - insertPoint - 1);
                System.arraycopy(this.values, insertPoint, this.values, insertPoint + 1, this.values.length - insertPoint - 1);
            }
            this.keys[insertPoint] = key;
            this.values[insertPoint] = value;
            ++this.size;
        } else {
            this.values[ix] = value;
        }
    }

    public boolean containsKey(int key) {
        return IntMap.binarySearch(this.keys, this.size, key) >= 0;
    }

    public V get(int key) {
        int ix = IntMap.binarySearch(this.keys, this.size, key);
        if (ix >= 0) {
            return (V)this.values[ix];
        }
        return null;
    }

    public void remove(int key) {
        int ix = IntMap.binarySearch(this.keys, this.size, key);
        if (ix >= 0) {
            if (ix <= this.size - 1) {
                System.arraycopy(this.keys, ix + 1, this.keys, ix, this.size - ix - 1);
                System.arraycopy(this.values, ix + 1, this.values, ix, this.size - ix - 1);
            }
            --this.size;
            this.keys[this.size] = 0;
            this.values[this.size] = null;
        }
    }

    public void clear() {
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    public void removeFromStart(int count) {
        if (count > 0 && count <= this.size) {
            if (count < this.size) {
                System.arraycopy(this.keys, count, this.keys, 0, this.size - count);
                System.arraycopy(this.values, count, this.values, 0, this.size - count);
            }
            int i = this.size - count;
            while (i < this.size) {
                this.keys[i] = 0;
                this.values[i] = null;
                ++i;
            }
            this.size -= count;
        }
    }

    public Iterator<Map.Entry<Integer, V>> entryIterator() {
        return new Iterator<Map.Entry<Integer, V>>(){
            private int i = 0;
            private final 1E entry;
            private final int _size;
            private final int[] _keys;
            private final Object[] _values;
            {
                class 1E
                implements Map.Entry<Integer, V> {
                    private Integer key;
                    private V value;

                    1E() {
                    }

                    @Override
                    public Integer getKey() {
                        return this.key;
                    }

                    @Override
                    public V getValue() {
                        return this.value;
                    }

                    @Override
                    public V setValue(V value) {
                        throw new UnsupportedOperationException();
                    }

                    void init(Integer k, V v) {
                        this.key = k;
                        this.value = v;
                    }
                }
                this.entry = new 1E();
                this._size = IntMap.this.size;
                this._keys = IntMap.this.keys;
                this._values = IntMap.this.values;
            }

            @Override
            public boolean hasNext() {
                return this.i < this._size;
            }

            @Override
            public Map.Entry<Integer, V> next() {
                if (this.i >= this._size) {
                    throw new NoSuchElementException();
                }
                Object val = this._values[this.i];
                this.entry.init(this._keys[this.i], val);
                ++this.i;
                return this.entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<Integer, ? super V> fill(Map<Integer, ? super V> map) {
        Iterator<Map.Entry<Integer, V>> it = this.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Integer, V> next = it.next();
            map.put(next.getKey(), next.getValue());
        }
        return map;
    }

    public int[] keys() {
        int[] rv = new int[this.size];
        System.arraycopy(this.keys, 0, rv, 0, this.size);
        return rv;
    }

    public Collection<V> values() {
        Object[] rv = new Object[this.size];
        System.arraycopy(this.values, 0, rv, 0, this.size);
        return Arrays.asList(rv);
    }

    private static int binarySearch(int[] a, int high, int key) {
        int low = 0;
        --high;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

