/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tmatesoft.hg.internal.IntTuple;
import org.tmatesoft.hg.internal.IntVector;

public final class IntSliceSeq
implements Iterable<IntTuple>,
Cloneable {
    private final IntVector slices;
    private final int slice;

    public IntSliceSeq(int sliceSize) {
        this(sliceSize, 10, 5);
    }

    public IntSliceSeq(int sliceSize, int initialSlices, int slicesToGrow) {
        this.slices = new IntVector(sliceSize * initialSlices, sliceSize * slicesToGrow);
        this.slice = sliceSize;
    }

    public IntSliceSeq add(int ... values) {
        this.checkValuesAny(values);
        this.slices.add(values);
        return this;
    }

    public IntSliceSeq set(int sliceIndex, int ... values) {
        this.checkValuesExact(values);
        int i = 0;
        int j = sliceIndex * this.slice;
        while (i < this.slice) {
            this.slices.set(j, values[i]);
            ++i;
            ++j;
        }
        return this;
    }

    public IntTuple get(int sliceIndex) {
        this.checkArgRange(this.size(), sliceIndex);
        return new IntTuple(this.slice).set(this.slices, sliceIndex * this.slice);
    }

    public int get(int sliceIndex, int valueIndex) {
        this.checkArgRange(this.size(), sliceIndex);
        this.checkArgRange(this.slice, valueIndex);
        return this.slices.get(sliceIndex * this.slice + valueIndex);
    }

    public void addAll(IntSliceSeq other) {
        if (other.slice != this.slice) {
            throw new IllegalArgumentException(String.format("Tuple size doesn't match: %d and %d", this.slice, other.slice));
        }
        this.slices.addAll(other.slices);
    }

    public int size() {
        return this.slices.size() / this.slice;
    }

    public int sliceSize() {
        return this.slice;
    }

    public void clear() {
        this.slices.clear();
    }

    public IntTuple last() {
        int lastElementIndex = this.size() - 1;
        if (lastElementIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.get(lastElementIndex);
    }

    @Override
    public Iterator<IntTuple> iterator() {
        return new Iterator<IntTuple>(){
            private final IntTuple t;
            private int next;
            {
                this.t = new IntTuple(IntSliceSeq.this.slice);
                this.next = 0;
            }

            @Override
            public boolean hasNext() {
                return this.next < IntSliceSeq.this.size();
            }

            @Override
            public IntTuple next() {
                return this.t.set(IntSliceSeq.this.slices, this.next++ * IntSliceSeq.this.slice);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            sb.append('(');
            int j = 0;
            while (j < this.slice) {
                sb.append(this.slices.get(i * this.slice + j));
                sb.append(',');
                ++j;
            }
            sb.setLength(sb.length() - 1);
            sb.append(')');
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public IntSliceSeq clone() {
        try {
            return (IntSliceSeq)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex);
        }
    }

    private void checkArgRange(int rangeSize, int index) {
        if (index >= 0 && index < rangeSize) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(index));
    }

    private void checkValuesExact(int[] values) {
        if (values == null || values.length != this.slice) {
            throw new IllegalArgumentException(String.valueOf(values == null ? values : (int[])values.length));
        }
    }

    private void checkValuesAny(int[] values) {
        if (values == null || values.length % this.slice != 0) {
            throw new IllegalArgumentException(String.valueOf(values == null ? values : (int[])values.length));
        }
    }
}

