/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;

public class IntVector
implements Cloneable {
    private int[] data;
    private final int increment;
    private int count;

    public IntVector() {
        this(16, -1);
    }

    public IntVector(int initialCapacity, int increment) {
        this.data = new int[initialCapacity];
        this.increment = increment;
    }

    public void add(int v) {
        if (this.count == this.data.length) {
            this.grow(0);
        }
        this.data[this.count++] = v;
    }

    public void add(int ... values) {
        if (this.count + values.length > this.data.length) {
            this.grow(this.count + values.length);
        }
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            this.data[this.count++] = v;
            ++n2;
        }
    }

    public void addAll(IntVector other) {
        int otherLen = other.count;
        if (this.count + otherLen > this.data.length) {
            this.grow(this.count + otherLen);
        }
        int i = 0;
        while (i < otherLen) {
            this.data[this.count++] = other.data[i];
            ++i;
        }
    }

    public int get(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, size: %d", i, this.count));
        }
        return this.data[i];
    }

    public void set(int i, int v) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, size: %d", i, this.count));
        }
        this.data[i] = v;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.count = 0;
    }

    public void trimTo(int newSize) {
        if (newSize < 0 || newSize > this.count) {
            throw new IllegalArgumentException(String.format("Can't trim vector of size %d to %d", this.count, newSize));
        }
        this.count = newSize;
    }

    public void trimToSize() {
        this.data = this.toArray(true);
    }

    public int[] toArray() {
        int[] rv = new int[this.count];
        System.arraycopy(this.data, 0, rv, 0, this.count);
        return rv;
    }

    public void reverse() {
        int a = 0;
        int b = this.count - 1;
        while (a < b) {
            int t = this.data[b];
            this.data[b] = this.data[a];
            this.data[a] = t;
            ++a;
            --b;
        }
    }

    public void sort(boolean ascending) {
        Arrays.sort(this.data, 0, this.count);
        if (!ascending) {
            this.reverse();
        }
    }

    public String toString() {
        return String.format("%s[%d]", IntVector.class.getSimpleName(), this.size());
    }

    public IntVector clone() {
        try {
            return (IntVector)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex);
        }
    }

    int[] toArray(boolean internalIfSizeMatchCapacity) {
        if (this.count == this.data.length) {
            return this.data;
        }
        return this.toArray();
    }

    private void grow(int newCapacityHint) {
        int newCapacity;
        if (this.increment == 0) {
            throw new UnsupportedOperationException("This vector is not allowed to expand");
        }
        int n = newCapacity = this.increment < 0 ? this.data.length << 1 : this.data.length + this.increment;
        if (newCapacityHint > 0 && newCapacity < newCapacityHint) {
            newCapacity = newCapacityHint;
        }
        assert (newCapacity > 0 && newCapacity != this.data.length) : newCapacity;
        int[] newData = new int[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.count);
        this.data = newData;
    }
}

