/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.internal.DataAccessProvider;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.Filter;
import org.tmatesoft.hg.internal.KeywordFilter;
import org.tmatesoft.hg.internal.NewlineFilter;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.RepoInitializer;
import org.tmatesoft.hg.internal.RevlogChangeMonitor;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.RevlogStreamFactory;
import org.tmatesoft.hg.internal.WinToNixPathRewrite;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgRepoConfig;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public final class Internals
implements SessionContext.Source {
    public static final String CFG_PROPERTY_HG_INSTALL_ROOT = "hg4j.hg.install_root";
    public static final String CFG_PROPERTY_REVLOG_STREAM_CACHE = "hg4j.repo.disable_revlog_cache";
    public static final String CFG_PROPERTY_FS_FILENAME_ENCODING = "hg.fs.filename.encoding";
    public static final String CFG_PROPERTY_FS_LOCK_TIMEOUT = "hg4j.fs.lock.timeout";
    public static final String CFG_PROPERTY_PATCH_MERGE = "hg4j.repo.merge_revlog_patches";
    public static final String CFG_PROPERTY_CREATE_PHASEROOTS = "hg4j.repo.create_phaseroots";
    public static final int REVLOGV1_RECORD_SIZE = 64;
    private List<Filter.Factory> filterFactories;
    private final HgRepository repo;
    private final File repoDir;
    private final boolean isCaseSensitiveFileSystem;
    private final DataAccessProvider dataAccess;
    private final ImplAccess implAccess;
    private final int requiresFlags;
    private final PathRewrite dataPathHelper;
    private final PathRewrite repoPathHelper;
    private final boolean shallMergePatches;
    private final boolean shallWritePhaseroots;
    private final RevlogStreamFactory streamProvider;

    public Internals(HgRepository hgRepo, File hgDir, ImplAccess implementationAccess) throws HgRuntimeException {
        this.repo = hgRepo;
        this.repoDir = hgDir;
        this.implAccess = implementationAccess;
        this.isCaseSensitiveFileSystem = !Internals.runningOnWindows();
        SessionContext ctx = this.repo.getSessionContext();
        this.dataAccess = new DataAccessProvider(ctx);
        RepoInitializer repoInit = new RepoInitializer().initRequiresFromFile(this.repoDir);
        this.requiresFlags = repoInit.getRequires();
        this.dataPathHelper = repoInit.buildDataFilesHelper(this.getSessionContext());
        this.repoPathHelper = repoInit.buildStoreFilesHelper();
        PropertyMarshal pm = new PropertyMarshal(ctx);
        boolean shallCacheRevlogsInRepo = pm.getBoolean(CFG_PROPERTY_REVLOG_STREAM_CACHE, true);
        this.streamProvider = new RevlogStreamFactory(this, shallCacheRevlogsInRepo);
        this.shallMergePatches = pm.getBoolean(CFG_PROPERTY_PATCH_MERGE, true);
        this.shallWritePhaseroots = pm.getBoolean(CFG_PROPERTY_CREATE_PHASEROOTS, false);
    }

    public boolean isInvalid() {
        return !this.repoDir.exists() || !this.repoDir.isDirectory();
    }

    public File getRepositoryFile(HgRepositoryFiles f) {
        switch (f.getHome()) {
            case Store: {
                return this.getFileFromStoreDir(f.getName());
            }
            case Repo: {
                return this.getFileFromRepoDir(f.getName());
            }
        }
        return new File(this.repo.getWorkingDir(), f.getName());
    }

    public File getFileFromRepoDir(String name) {
        return new File(this.repoDir, name);
    }

    public File getFileFromStoreDir(String name) {
        CharSequence location = this.repoPathHelper.rewrite(name);
        return new File(this.repoDir, location.toString());
    }

    public File getFileFromDataDir(CharSequence path) {
        CharSequence storagePath = this.dataPathHelper.rewrite(path);
        return new File(this.repoDir, storagePath.toString());
    }

    @Override
    public SessionContext getSessionContext() {
        return this.repo.getSessionContext();
    }

    public LogFacility getLog() {
        return this.getSessionContext().getLog();
    }

    public HgRepository getRepo() {
        return this.repo;
    }

    public DataAccessProvider getDataAccess() {
        return this.dataAccess;
    }

    public PathRewrite buildNormalizePathRewrite() {
        if (Internals.runningOnWindows()) {
            return new WinToNixPathRewrite();
        }
        return new PathRewrite.Empty();
    }

    public List<Filter.Factory> getFilters() {
        if (this.filterFactories == null) {
            Filter.Factory ff;
            this.filterFactories = new ArrayList<Filter.Factory>();
            HgRepoConfig.ExtensionsSection cfg = this.repo.getConfiguration().getExtensions();
            if (cfg.isEnabled("eol")) {
                ff = new NewlineFilter.Factory();
                ((NewlineFilter.Factory)ff).initialize(this.repo);
                this.filterFactories.add(ff);
            }
            if (cfg.isEnabled("keyword")) {
                ff = new KeywordFilter.Factory();
                ((KeywordFilter.Factory)ff).initialize(this.repo);
                this.filterFactories.add(ff);
            }
        }
        return this.filterFactories;
    }

    public boolean isCaseSensitiveFileSystem() {
        return this.isCaseSensitiveFileSystem;
    }

    public boolean fncacheInUse() {
        return (this.getRequiresFlags() & 2) != 0;
    }

    public EncodingHelper buildFileNameEncodingHelper() {
        return new EncodingHelper(Internals.getFileEncoding(this.getSessionContext()), this.repo);
    }

    public static EncodingHelper buildFileNameEncodingHelper(SessionContext.Source ctx) {
        return new EncodingHelper(Internals.getFileEncoding(ctx.getSessionContext()), ctx);
    }

    static Charset getFileEncoding(SessionContext ctx) {
        Charset cs;
        Object altEncoding = ctx.getConfigurationProperty(CFG_PROPERTY_FS_FILENAME_ENCODING, null);
        if (altEncoding == null) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(altEncoding.toString());
            }
            catch (IllegalArgumentException ex) {
                ctx.getLog().dump(Internals.class, LogFacility.Severity.Error, ex, String.format("Bad configuration value for filename encoding %s", altEncoding));
                cs = Charset.defaultCharset();
            }
        }
        return cs;
    }

    public CharSequence getStoragePath(HgDataFile df) {
        return this.dataPathHelper.rewrite(df.getPath().toString());
    }

    public int getRequiresFlags() {
        return this.requiresFlags;
    }

    boolean shallMergePatches() {
        return this.shallMergePatches;
    }

    boolean shallCreatePhaseroots() {
        return this.shallWritePhaseroots;
    }

    RevlogChangeMonitor getRevlogTracker(File f) {
        return new RevlogChangeMonitor(f);
    }

    public static boolean runningOnWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean checkSupportsExecutables(File fsHint) {
        return !Internals.runningOnWindows();
    }

    public static boolean checkSupportsSymlinks(File fsHint) {
        return !Internals.runningOnWindows();
    }

    private static File findHgInstallRoot(SessionContext ctx) {
        String p = (String)ctx.getConfigurationProperty(CFG_PROPERTY_HG_INSTALL_ROOT, null);
        if (p != null) {
            return new File(p);
        }
        StringTokenizer st = new StringTokenizer(System.getenv("PATH"), System.getProperty("path.separator"), false);
        boolean runsOnWin = Internals.runningOnWindows();
        while (st.hasMoreTokens()) {
            String pe = st.nextToken();
            File execCandidate = new File(pe, runsOnWin ? "hg.exe" : "hg");
            if (!execCandidate.exists() || !execCandidate.isFile()) continue;
            File execDir = execCandidate.getParentFile();
            return runsOnWin ? execDir : execDir.getParentFile();
        }
        return null;
    }

    public static ConfigFile readConfiguration(SessionContext sessionCtx) throws HgIOException {
        ConfigFile configFile = new ConfigFile(sessionCtx);
        File hgInstallRoot = Internals.findHgInstallRoot(sessionCtx);
        if (Internals.runningOnWindows()) {
            if (hgInstallRoot != null) {
                for (File f : Internals.getWindowsConfigFilesPerInstall(hgInstallRoot)) {
                    configFile.addLocation(f);
                }
            }
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            locations.add(System.getenv("USERPROFILE"));
            locations.add(System.getenv("HOME"));
            locations.remove(null);
            for (String loc : locations) {
                File location = new File(loc);
                configFile.addLocation(new File(location, "Mercurial.ini"));
                configFile.addLocation(new File(location, ".hgrc"));
            }
        } else {
            File d;
            if (hgInstallRoot != null) {
                d = new File(hgInstallRoot, "etc/mercurial/hgrc.d/");
                if (d.isDirectory() && d.canRead()) {
                    for (File f : Internals.listConfigFiles(d)) {
                        configFile.addLocation(f);
                    }
                }
                configFile.addLocation(new File(hgInstallRoot, "etc/mercurial/hgrc"));
            }
            if ((d = new File("/etc/mercurial/hgrc.d/")).isDirectory() && d.canRead()) {
                for (File f : Internals.listConfigFiles(d)) {
                    configFile.addLocation(f);
                }
            }
            configFile.addLocation(new File("/etc/mercurial/hgrc"));
            configFile.addLocation(new File(System.getenv("HOME"), ".hgrc"));
        }
        return configFile;
    }

    public ConfigFile readConfiguration() throws HgIOException {
        ConfigFile configFile = Internals.readConfiguration(this.repo.getSessionContext());
        configFile.addLocation(this.getFileFromRepoDir("hgrc"));
        return configFile;
    }

    ImplAccess getImplAccess() {
        return this.implAccess;
    }

    private static List<File> getWindowsConfigFilesPerInstall(File hgInstallDir) {
        File f = new File(hgInstallDir, "Mercurial.ini");
        if (f.exists()) {
            return Collections.singletonList(f);
        }
        f = new File(hgInstallDir, "hgrc.d/");
        if (f.canRead() && f.isDirectory()) {
            return Internals.listConfigFiles(f);
        }
        f = new File("C:\\Mercurial\\Mercurial.ini");
        if (f.exists()) {
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    private static List<File> listConfigFiles(File dir) {
        assert (dir.canRead());
        assert (dir.isDirectory());
        Object[] allFiles = dir.listFiles();
        Arrays.sort(allFiles);
        ArrayList<File> rv = new ArrayList<File>(allFiles.length);
        Object[] objectArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            if (((File)f).getName().endsWith(".rc")) {
                rv.add((File)f);
            }
            ++n2;
        }
        return rv;
    }

    public static File getInstallationConfigurationFileToWrite(SessionContext ctx) {
        File cfg;
        File hgInstallRoot = Internals.findHgInstallRoot(ctx);
        if (hgInstallRoot != null && ((cfg = new File(hgInstallRoot, Internals.runningOnWindows() ? "Mercurial.ini" : "etc/mercurial/hgrc")).canWrite() || cfg.getParentFile().canWrite())) {
            return cfg;
        }
        if (Internals.runningOnWindows()) {
            if (hgInstallRoot == null) {
                return new File("C:\\Mercurial\\Mercurial.ini");
            }
            return new File(hgInstallRoot, "Mercurial.ini");
        }
        return new File("/etc/mercurial/hgrc");
    }

    public static File getUserConfigurationFileToWrite(SessionContext ctx) {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        boolean runsOnWindows = Internals.runningOnWindows();
        if (runsOnWindows) {
            locations.add(System.getenv("USERPROFILE"));
        }
        locations.add(System.getenv("HOME"));
        locations.remove(null);
        for (String loc : locations) {
            File location = new File(loc);
            File rv = new File(location, ".hgrc");
            if (rv.exists() && rv.canWrite()) {
                return rv;
            }
            if (!runsOnWindows || !(rv = new File(location, "Mercurial.ini")).exists() || !rv.canWrite()) continue;
            return rv;
        }
        return new File(System.getProperty("user.home"), ".hgrc");
    }

    public RevlogStream createManifestStream() {
        File manifestFile = this.getFileFromStoreDir("00manifest.i");
        return this.streamProvider.create(manifestFile);
    }

    public RevlogStream createChangelogStream() {
        File chlogFile = this.getFileFromStoreDir("00changelog.i");
        return this.streamProvider.create(chlogFile);
    }

    public RevlogStream resolveStoreFile(Path path) {
        return this.streamProvider.getStoreFile(path, false);
    }

    public static IllegalStateException notImplemented() {
        return new IllegalStateException("Not implemented");
    }

    public static Internals getInstance(HgRepository repo) {
        return HgInternals.getImplementationRepo(repo);
    }

    public static <T> CharSequence join(Iterable<T> col, CharSequence separator) {
        if (col == null) {
            return String.valueOf(col);
        }
        Iterator<T> it = col.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        String v = String.valueOf(it.next());
        StringBuilder sb = new StringBuilder(v);
        while (it.hasNext()) {
            sb.append(separator);
            v = String.valueOf(it.next());
            sb.append(v);
        }
        return sb;
    }

    public static int ltoi(long l) {
        int i = (int)l;
        assert ((long)i == l) : "Loss of data!";
        return i;
    }

    public static interface ImplAccess {
        public RevlogStream getStream(HgDataFile var1);

        public RevlogStream getManifestStream();

        public RevlogStream getChangelogStream();
    }
}

