/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Filter;
import org.tmatesoft.hg.internal.PathGlobMatcher;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;

public class KeywordFilter
implements Filter {
    private final HgRepository repo;
    private final boolean isExpanding;
    private final TreeMap<String, String> keywords;
    private final int minBufferLen;
    private final Path path;
    private HgChangelog.RawChangeset latestFileCset;

    private KeywordFilter(HgRepository hgRepo, Path p, boolean expand) {
        this.repo = hgRepo;
        this.path = p;
        this.isExpanding = expand;
        this.keywords = new TreeMap();
        this.keywords.put("Id", "Id");
        this.keywords.put("Revision", "Revision");
        this.keywords.put("Author", "Author");
        this.keywords.put("Date", "Date");
        this.keywords.put("LastChangedRevision", "LastChangedRevision");
        this.keywords.put("LastChangedBy", "LastChangedBy");
        this.keywords.put("LastChangedDate", "LastChangedDate");
        this.keywords.put("Source", "Source");
        this.keywords.put("Header", "Header");
        int l = 0;
        for (String s : this.keywords.keySet()) {
            if (s.length() <= l) continue;
            l = s.length();
        }
        this.minBufferLen = l + 2 + (this.isExpanding ? 0 : 120);
    }

    @Override
    public ByteBuffer filter(ByteBuffer src) {
        int x;
        if (src.capacity() < this.minBufferLen) {
            throw new IllegalStateException(String.format("Need buffer of at least %d bytes to ensure filter won't hang", this.minBufferLen));
        }
        ByteBuffer rv = null;
        int keywordStart = -1;
        int copyFrom = x = src.position();
        while (x < src.limit()) {
            int i;
            if (keywordStart == -1) {
                i = KeywordFilter.indexOf(src, '$', x, false);
                if (i == -1) {
                    if (rv == null) {
                        return src;
                    }
                    KeywordFilter.copySlice(src, copyFrom, src.limit(), rv);
                    rv.flip();
                    src.position(src.limit());
                    return rv;
                }
                keywordStart = i;
            }
            if (keywordStart < 0) continue;
            i = KeywordFilter.indexOf(src, '$', keywordStart + 1, true);
            if (i == -1) {
                if (rv == null) {
                    if (keywordStart == x) {
                        throw new IllegalStateException("Try src buffer of a greater size");
                    }
                    rv = ByteBuffer.allocate(keywordStart - copyFrom);
                }
                KeywordFilter.copySlice(src, copyFrom, keywordStart, rv);
                rv.flip();
                src.position(keywordStart);
                return rv;
            }
            if (src.get(i) == 36) {
                String keyword = this.matchKeyword(src, keywordStart, i);
                if (keyword != null) {
                    if (rv == null) {
                        rv = ByteBuffer.allocate(this.isExpanding ? src.remaining() * 4 : src.remaining());
                    }
                    KeywordFilter.copySlice(src, copyFrom, keywordStart + 1, rv);
                    rv.put(keyword.getBytes());
                    if (this.isExpanding) {
                        rv.put((byte)58);
                        rv.put((byte)32);
                        this.expandKeywordValue(keyword, rv);
                        rv.put((byte)32);
                    }
                    rv.put((byte)36);
                    keywordStart = -1;
                    copyFrom = x = i + 1;
                    continue;
                }
                if (rv != null) {
                    KeywordFilter.copySlice(src, x, i, rv);
                    copyFrom = i;
                }
                keywordStart = i;
                x = i;
                continue;
            }
            assert (src.get(i) == 10 || src.get(i) == 13);
            if (rv != null) {
                KeywordFilter.copySlice(src, x, i + 1, rv);
                copyFrom = i + 1;
            }
            x = i + 1;
            keywordStart = -1;
        }
        if (keywordStart != -1) {
            if (rv == null) {
                rv = ByteBuffer.allocate(keywordStart - src.position());
                KeywordFilter.copySlice(src, src.position(), keywordStart, rv);
            }
            src.position(keywordStart);
        }
        if (rv != null) {
            rv.flip();
            return rv;
        }
        return src;
    }

    private void expandKeywordValue(String keyword, ByteBuffer rv) {
        if ("Id".equals(keyword)) {
            rv.put(this.identityString().getBytes());
        } else if ("Revision".equals(keyword)) {
            rv.put(this.revision().getBytes());
        } else if ("Author".equals(keyword)) {
            rv.put(this.username().getBytes());
        } else if ("Date".equals(keyword)) {
            rv.put(this.date().getBytes());
        } else {
            throw new IllegalStateException(String.format("Keyword %s is not yet supported", keyword));
        }
    }

    private String matchKeyword(ByteBuffer src, int kwStart, int kwEnd) {
        assert (kwEnd - kwStart - 1 > 0);
        assert (src.get(kwStart) == src.get(kwEnd) && src.get(kwEnd) == 36);
        char[] chars = new char[kwEnd - kwStart - 1];
        int i = 0;
        while (i < chars.length) {
            char c = (char)src.get(kwStart + 1 + i);
            if (c == ':') break;
            chars[i] = c;
            ++i;
        }
        String kw = new String(chars, 0, i);
        return this.keywords.get(kw);
    }

    static void copySlice(ByteBuffer src, int from, int to, ByteBuffer dst) {
        if (to > src.limit()) {
            throw new IllegalArgumentException("Bad right boundary");
        }
        if (dst.remaining() < to - from) {
            throw new IllegalArgumentException("Not enough room in the destination buffer");
        }
        int i = from;
        while (i < to) {
            dst.put(src.get(i));
            ++i;
        }
    }

    private static int indexOf(ByteBuffer b, char ch, int from, boolean newlineBreaks) {
        int i = from;
        while (i < b.limit()) {
            byte c = b.get(i);
            if (ch == c) {
                return i;
            }
            if (newlineBreaks && (c == 10 || c == 13)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String identityString() {
        return String.format("%s,v %s %s %s", this.path, this.revision(), this.date(), this.username());
    }

    private String revision() {
        try {
            int csetRev = this.repo.getFileNode(this.path).getChangesetRevisionIndex(-3);
            return this.repo.getChangelog().getRevision(csetRev).shortNotation();
        }
        catch (HgRuntimeException ex) {
            this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
            return Nodeid.NULL.shortNotation();
        }
    }

    private String username() {
        try {
            return this.getChangeset().user();
        }
        catch (HgRuntimeException ex) {
            this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
            return "";
        }
    }

    private String date() {
        Date d;
        try {
            d = this.getChangeset().date();
        }
        catch (HgRuntimeException ex) {
            this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
            d = new Date(0L);
        }
        return String.format("%tY/%<tm/%<td %<tH:%<tM:%<tS", d);
    }

    private HgChangelog.RawChangeset getChangeset() throws HgRuntimeException {
        if (this.latestFileCset == null) {
            int csetRev = this.repo.getFileNode(this.path).getChangesetRevisionIndex(-3);
            this.latestFileCset = this.repo.getChangelog().range(csetRev, csetRev).get(0);
        }
        return this.latestFileCset;
    }

    /* synthetic */ KeywordFilter(HgRepository hgRepository, Path path, boolean bl, KeywordFilter keywordFilter) {
        this(hgRepository, path, bl);
    }

    public static class Factory
    implements Filter.Factory {
        private HgRepository repo;
        private Path.Matcher matcher;

        @Override
        public void initialize(HgRepository hgRepo) {
            this.repo = hgRepo;
            ArrayList<String> patterns = new ArrayList<String>();
            for (Pair<String, String> e : hgRepo.getConfiguration().getSection("keyword")) {
                if ("ignore".equalsIgnoreCase(e.second())) continue;
                patterns.add(e.first());
            }
            this.matcher = new PathGlobMatcher(patterns.toArray(new String[patterns.size()]));
        }

        @Override
        public Filter create(Path path, Filter.Options opts) {
            if (this.matcher.accept(path)) {
                return new KeywordFilter(this.repo, path, opts.getDirection() == Filter.Direction.FromRepo, null);
            }
            return null;
        }
    }
}

