/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class LifecycleBridge
implements Lifecycle {
    private final ProgressSupport progressHelper;
    private final CancelSupport cancelSupport;
    private Lifecycle.Callback receiver;
    private CancelledException cancellation;

    public LifecycleBridge(ProgressSupport progress, CancelSupport cancel) {
        this.progressHelper = progress;
        this.cancelSupport = cancel;
    }

    @Override
    public void start(int count, Lifecycle.Callback callback, Object token) {
        this.receiver = callback;
        if (this.progressHelper != null) {
            this.progressHelper.start(count);
        }
    }

    @Override
    public void finish(Object token) {
        if (this.progressHelper != null) {
            this.progressHelper.done();
        }
        this.receiver = null;
    }

    public void nextStep() {
        if (this.progressHelper != null) {
            this.progressHelper.worked(1);
        }
        if (this.cancelSupport == null) {
            return;
        }
        try {
            this.cancelSupport.checkCancelled();
        }
        catch (CancelledException ex) {
            if (this.receiver != null) {
                this.receiver.stop();
            }
            this.cancellation = ex;
        }
    }

    public void stop() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
    }

    public boolean isCancelled() {
        return this.cancellation != null;
    }

    public CancelledException getCancelOrigin() {
        return this.cancellation;
    }
}

