/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.util.LogFacility;

public final class LineReader {
    private final File file;
    private final LogFacility log;
    private final Charset encoding;
    private boolean trimLines = true;
    private boolean skipEmpty = true;
    private String ignoreThatStarts = null;

    public LineReader(File f, LogFacility logFacility) {
        this(f, logFacility, null);
    }

    public LineReader(File f, LogFacility logFacility, Charset lineEncoding) {
        this.file = f;
        this.log = logFacility;
        this.encoding = lineEncoding;
    }

    public LineReader trimLines(boolean trim) {
        this.trimLines = trim;
        return this;
    }

    public LineReader skipEmpty(boolean skip) {
        this.skipEmpty = skip;
        return this;
    }

    public LineReader ignoreLineComments(String lineStart) {
        this.ignoreThatStarts = lineStart;
        return this;
    }

    public <T> T read(LineConsumer<T> consumer, T paramObj) throws HgIOException {
        T t;
        BufferedReader statusFileReader = null;
        try {
            String line;
            InputStreamReader fileReader = this.encoding == null ? new FileReader(this.file) : new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
            statusFileReader = new BufferedReader(fileReader);
            boolean ok = true;
            while (ok && (line = statusFileReader.readLine()) != null) {
                if (this.trimLines) {
                    line = line.trim();
                }
                if (this.ignoreThatStarts != null && line.startsWith(this.ignoreThatStarts) || this.skipEmpty && line.length() <= 0) continue;
                ok = consumer.consume(line, paramObj);
            }
            t = paramObj;
            new FileUtils(this.log, this).closeQuietly(statusFileReader);
        }
        catch (IOException ex) {
            try {
                throw new HgIOException(ex.getMessage(), ex, this.file);
            }
            catch (Throwable throwable) {
                new FileUtils(this.log, this).closeQuietly(statusFileReader);
                throw throwable;
            }
        }
        return t;
    }

    public static interface LineConsumer<T> {
        public boolean consume(String var1, T var2) throws IOException;
    }

    public static class SimpleLineCollector
    implements LineConsumer<Collection<String>> {
        @Override
        public boolean consume(String line, Collection<String> result) throws IOException {
            result.add(line);
            return true;
        }
    }
}

