/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.EncodingHelper;

public class ManifestEntryBuilder
implements DataSerializer.DataSource {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final EncodingHelper encHelper;

    public ManifestEntryBuilder(EncodingHelper encodingHelper) {
        this.encHelper = encodingHelper;
    }

    public ManifestEntryBuilder reset() {
        this.buffer.reset();
        return this;
    }

    public ManifestEntryBuilder add(String fname, Nodeid revision) {
        byte[] b = this.encHelper.toManifest(fname);
        this.buffer.write(b, 0, b.length);
        this.buffer.write(0);
        b = revision.toString().getBytes();
        this.buffer.write(b, 0, b.length);
        this.buffer.write(10);
        return this;
    }

    public byte[] build() {
        return this.buffer.toByteArray();
    }

    @Override
    public void serialize(DataSerializer out) throws HgIOException {
        byte[] r = this.build();
        out.write(r, 0, r.length);
    }

    @Override
    public int serializeLength() {
        return this.buffer.size();
    }
}

