/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Collection;
import java.util.TreeMap;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Pool;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.util.Convertor;
import org.tmatesoft.hg.util.Path;

public final class ManifestRevision
implements HgManifest.Inspector {
    private final TreeMap<Path, Nodeid> idsMap;
    private final TreeMap<Path, HgManifest.Flags> flagsMap;
    private final Convertor<Nodeid> idsPool;
    private final Convertor<Path> namesPool;
    private Nodeid manifestRev = Nodeid.NULL;
    private int changelogRevIndex = -1;
    private int manifestRevIndex = -1;

    public ManifestRevision(Pool<Nodeid> nodeidPool, Convertor<Path> filenamePool) {
        this.idsPool = nodeidPool;
        this.namesPool = filenamePool;
        this.idsMap = new TreeMap();
        this.flagsMap = new TreeMap();
    }

    public Collection<Path> files() {
        return this.idsMap.keySet();
    }

    public Nodeid nodeid(Path fname) {
        return this.idsMap.get(fname);
    }

    public HgManifest.Flags flags(Path fname) {
        HgManifest.Flags f = this.flagsMap.get(fname);
        return f == null ? HgManifest.Flags.RegularFile : f;
    }

    public Nodeid revision() {
        return this.manifestRev;
    }

    public int revisionIndex() {
        return this.manifestRevIndex;
    }

    public int changesetRevisionIndex() {
        return this.changelogRevIndex;
    }

    @Override
    public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
        if (this.namesPool != null) {
            fname = this.namesPool.mangle(fname);
        }
        if (this.idsPool != null) {
            nid = this.idsPool.mangle(nid);
        }
        this.idsMap.put(fname, nid);
        if (flags != HgManifest.Flags.RegularFile) {
            this.flagsMap.put(fname, flags);
        }
        return true;
    }

    @Override
    public boolean end(int revision) {
        return false;
    }

    @Override
    public boolean begin(int revisionIndex, Nodeid revision, int changelogRevisionIndex) {
        if (this.manifestRev != null) {
            this.idsMap.clear();
            this.flagsMap.clear();
        }
        this.manifestRev = revision;
        this.manifestRevIndex = revisionIndex;
        this.changelogRevIndex = changelogRevisionIndex;
        return true;
    }
}

