/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.util.LogFacility;

public final class Metadata {
    private final IntMap<Record> entries = new IntMap(5);
    private final Record NONE = new Record(-1, null);
    private final LogFacility log;
    private int lastRevRead = -1;

    public Metadata(SessionContext.Source sessionCtx) {
        this.log = sessionCtx.getSessionContext().getLog();
    }

    public boolean known(int revision) {
        Record i = this.entries.get(revision);
        return i != null && this.NONE != i;
    }

    public boolean checked(int revision) {
        return this.entries.containsKey(revision);
    }

    public boolean none(int revision) {
        Record i = this.entries.get(revision);
        return i == this.NONE;
    }

    public int lastRevisionRead() {
        return this.lastRevRead;
    }

    void recordNone(int revision) {
        Record i = this.entries.get(revision);
        if (i == this.NONE) {
            return;
        }
        if (i != null) {
            throw new HgInvalidStateException(String.format("Trying to override Metadata state for revision %d (known offset: %d)", revision, i));
        }
        this.entries.put(revision, this.NONE);
    }

    public int dataOffset(int revision) {
        return this.entries.get((int)revision).offset;
    }

    void add(int revision, int dataOffset, Collection<MetadataEntry> e) {
        assert (!this.entries.containsKey(revision));
        this.entries.put(revision, new Record(dataOffset, e.toArray(new MetadataEntry[e.size()])));
    }

    public boolean tryRead(int revisionNumber, DataAccess data) throws IOException, HgInvalidControlFileException {
        int daLength = data.length();
        if (this.lastRevRead == -1 || revisionNumber > this.lastRevRead) {
            this.lastRevRead = revisionNumber;
        }
        if (daLength < 4 || data.readByte() != 1 || data.readByte() != 10) {
            this.recordNone(revisionNumber);
            return false;
        }
        ArrayList<MetadataEntry> _metadata = new ArrayList<MetadataEntry>();
        int offset = this.parseMetadata(data, daLength, _metadata);
        this.add(revisionNumber, offset, _metadata);
        return true;
    }

    public String find(int revision, String key) {
        MetadataEntry[] metadataEntryArray = this.entries.get((int)revision).entries;
        int n = this.entries.get((int)revision).entries.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataEntry me = metadataEntryArray[n2];
            if (me.matchKey(key)) {
                return me.value();
            }
            ++n2;
        }
        return null;
    }

    private int parseMetadata(DataAccess data, int daLength, ArrayList<MetadataEntry> _metadata) throws IOException, HgInvalidControlFileException {
        int lastEntryStart = 2;
        int lastColon = -1;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String key = null;
        String value = null;
        boolean byteOne = false;
        boolean metadataIsComplete = false;
        int i = 2;
        while (i < daLength) {
            byte b = data.readByte();
            if (b == 10) {
                if (byteOne) {
                    lastEntryStart = i + 1;
                    metadataIsComplete = true;
                    break;
                }
                if (key == null || lastColon == -1 || i <= lastColon) {
                    this.log.dump(this.getClass(), LogFacility.Severity.Error, "Missing key in file revision metadata at index %d", i);
                }
                value = new String(bos.toByteArray()).trim();
                bos.reset();
                _metadata.add(new MetadataEntry(key, value));
                value = null;
                key = null;
                lastColon = -1;
                lastEntryStart = i + 1;
            } else {
                if (byteOne) {
                    bos.write(1);
                    byteOne = false;
                }
                if (b == 58) {
                    assert (value == null);
                    key = new String(bos.toByteArray());
                    bos.reset();
                    lastColon = i;
                } else if (b == 1) {
                    byteOne = true;
                } else {
                    bos.write(b);
                }
            }
            ++i;
        }
        if (!metadataIsComplete) {
            throw new HgInvalidControlFileException("Metadata is not closed properly", null, null);
        }
        return lastEntryStart;
    }

    private static class MetadataEntry {
        private final String entry;
        private final int valueStart;

        MetadataEntry(String key, String value) {
            if (key == null) {
                this.entry = value;
                this.valueStart = -1;
            } else {
                this.entry = String.valueOf(key) + value;
                this.valueStart = key.length();
            }
        }

        boolean matchKey(String key) {
            return key == null ? this.valueStart == -1 : key.length() == this.valueStart && this.entry.startsWith(key);
        }

        public String value() {
            return this.valueStart == -1 ? this.entry : this.entry.substring(this.valueStart);
        }
    }

    private static class Record {
        public final int offset;
        public final MetadataEntry[] entries;

        public Record(int off, MetadataEntry[] entr) {
            this.offset = off;
            this.entries = entr;
        }
    }
}

