/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.internal.Filter;
import org.tmatesoft.hg.internal.KeywordFilter;
import org.tmatesoft.hg.internal.PathGlobMatcher;
import org.tmatesoft.hg.internal.Preview;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;

public class NewlineFilter
implements Filter,
Preview,
Adaptable {
    private final boolean processInconsistent;
    private final boolean winToNix;
    private boolean foundLoneLF = false;
    private boolean foundCRLF = false;
    private boolean prevBufLastByteWasCR = false;
    private boolean previewDone = false;

    public static NewlineFilter createWin2Nix(boolean processMixed) {
        return new NewlineFilter(!processMixed, 0);
    }

    public static NewlineFilter createNix2Win(boolean processMixed) {
        return new NewlineFilter(!processMixed, 1);
    }

    private NewlineFilter(boolean onlyConsistent, int transform) {
        this.winToNix = transform == 0;
        this.processInconsistent = !onlyConsistent;
    }

    @Override
    public ByteBuffer filter(ByteBuffer src) {
        if (!this.processInconsistent && !this.previewDone) {
            throw new HgInvalidStateException("This filter requires preview operation prior to actual filtering when eol.only-consistent is true");
        }
        if (!this.processInconsistent && this.foundLoneLF && this.foundCRLF) {
            return src;
        }
        if (this.winToNix) {
            if (!this.processInconsistent && !this.foundCRLF) {
                return src;
            }
            return this.win2nix(src);
        }
        if (!this.processInconsistent && !this.foundLoneLF) {
            return src;
        }
        return this.nix2win(src);
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        if (Preview.class == adapterClass && !this.processInconsistent) {
            return adapterClass.cast(this);
        }
        return null;
    }

    @Override
    public void preview(ByteBuffer src) {
        this.previewDone = true;
        if (this.processInconsistent) {
            return;
        }
        if (this.foundLoneLF && this.foundCRLF) {
            return;
        }
        int x = src.position();
        while (x < src.limit()) {
            int in = NewlineFilter.indexOf((byte)10, src, x);
            if (in == -1) {
                this.prevBufLastByteWasCR = 13 == src.get(src.limit() - 1);
                return;
            }
            if (in == 0) {
                if (this.prevBufLastByteWasCR) {
                    this.foundCRLF = true;
                } else {
                    this.foundLoneLF = true;
                }
            } else if (src.get(in - 1) == 13) {
                this.foundCRLF = true;
            } else {
                this.foundLoneLF = true;
            }
            if (this.foundCRLF && this.foundLoneLF) {
                return;
            }
            x = in + 1;
        }
    }

    private ByteBuffer win2nix(ByteBuffer src) {
        int lookupStart = src.position();
        ByteBuffer dst = null;
        while (lookupStart < src.limit()) {
            int ir = NewlineFilter.indexOf((byte)13, src, lookupStart);
            int in = NewlineFilter.indexOf((byte)10, src, lookupStart);
            if (in != -1) {
                if (ir == -1 || ir > in) {
                    if (!this.processInconsistent && this.foundCRLF) {
                        assert (this.foundLoneLF) : "preview() shall initialize this";
                        this.fail(src, in);
                    }
                    dst = NewlineFilter.consume(src, lookupStart, in + 1, dst);
                    lookupStart = in + 1;
                    continue;
                }
                if (NewlineFilter.onlyCRup2limit(src, ir, in)) {
                    if (!this.processInconsistent && this.foundLoneLF) {
                        assert (this.foundCRLF) : "preview() shall initialize this";
                        this.fail(src, ir);
                    }
                    dst = NewlineFilter.consume(src, lookupStart, ir, dst);
                    dst.put((byte)10);
                    lookupStart = in + 1;
                    continue;
                }
                dst = NewlineFilter.consume(src, lookupStart, ir + 1, dst);
                lookupStart = ir + 1;
                continue;
            }
            if (ir != -1 && NewlineFilter.onlyCRup2limit(src, ir, src.limit())) {
                dst = NewlineFilter.consume(src, lookupStart, ir, dst);
                lookupStart = src.limit() - 1;
                break;
            }
            if (dst == null) break;
            KeywordFilter.copySlice(src, lookupStart, src.limit(), dst);
            lookupStart = src.limit();
            break;
        }
        src.position(lookupStart);
        return dst == null ? src : (ByteBuffer)dst.flip();
    }

    private static boolean onlyCRup2limit(ByteBuffer src, int from, int limit) {
        int i = from;
        while (i < limit) {
            if (src.get(i) != 13) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ByteBuffer consume(ByteBuffer src, int from, int to, ByteBuffer dst) {
        if (dst == null) {
            dst = ByteBuffer.allocate(src.remaining());
        }
        KeywordFilter.copySlice(src, from, to, dst);
        return dst;
    }

    private ByteBuffer nix2win(ByteBuffer src) {
        int x = src.position();
        ByteBuffer dst = null;
        while (x < src.limit()) {
            int in = NewlineFilter.indexOf((byte)10, src, x);
            if (in != -1) {
                if (in > x && src.get(in - 1) == 13) {
                    if (!this.processInconsistent && this.foundLoneLF) {
                        assert (this.foundCRLF) : "preview() shall initialize this";
                        this.fail(src, in - 1);
                    }
                    if (dst == null) {
                        dst = ByteBuffer.allocate(src.remaining() * 2);
                    }
                    KeywordFilter.copySlice(src, x, in + 1, dst);
                    x = in + 1;
                    continue;
                }
                if (!this.processInconsistent && this.foundCRLF) {
                    assert (this.foundLoneLF) : "preview() shall initialize this";
                    this.fail(src, in);
                }
                if (dst == null) {
                    dst = ByteBuffer.allocate(src.remaining() * 2);
                }
                KeywordFilter.copySlice(src, x, in, dst);
                dst.put((byte)13);
                dst.put((byte)10);
                x = in + 1;
                continue;
            }
            if (dst == null) break;
            KeywordFilter.copySlice(src, x, src.limit(), dst);
            x = src.limit();
            break;
        }
        src.position(x);
        return dst == null ? src : (ByteBuffer)dst.flip();
    }

    private void fail(ByteBuffer b, int pos) {
        StringBuilder sb = new StringBuilder();
        int i = Math.max(pos - 10, 0);
        int x = Math.min(pos + 10, b.limit());
        while (i < x) {
            sb.append(String.format("%02x ", b.get(i)));
            ++i;
        }
        throw new HgInvalidStateException(String.format("Inconsistent newline characters in the stream %s (char 0x%x, local index:%d)", sb.toString(), b.get(pos), pos));
    }

    private static int indexOf(byte ch, ByteBuffer b, int from) {
        return NewlineFilter.indexOf(ch, b, from, b.limit());
    }

    private static int indexOf(byte ch, ByteBuffer b, int from, int to) {
        int i = from;
        while (i < to) {
            byte c = b.get(i);
            if (ch == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /* synthetic */ NewlineFilter(boolean bl, int n, NewlineFilter newlineFilter) {
        this(bl, n);
    }

    public static class Factory
    implements Filter.Factory {
        private boolean processOnlyConsistent = true;
        private Path.Matcher lfMatcher;
        private Path.Matcher crlfMatcher;
        private Path.Matcher binMatcher;
        private Path.Matcher nativeMatcher;
        private String nativeRepoFormat;
        private String nativeOSFormat;

        @Override
        public void initialize(HgRepository hgRepo) {
            String os;
            this.processOnlyConsistent = hgRepo.getConfiguration().getBooleanValue("eol", "only-consistent", true);
            File cfgFile = new File(hgRepo.getWorkingDir(), ".hgeol");
            if (!cfgFile.canRead()) {
                return;
            }
            ConfigFile hgeol = new ConfigFile(hgRepo.getSessionContext());
            try {
                hgeol.addLocation(cfgFile);
            }
            catch (HgIOException ex) {
                hgRepo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
            }
            this.nativeRepoFormat = hgeol.getSection("repository").get("native");
            if (this.nativeRepoFormat == null) {
                this.nativeRepoFormat = "LF";
            }
            this.nativeOSFormat = (os = System.getProperty("os.name")).indexOf("Windows") != -1 ? "CRLF" : "LF";
            ArrayList<String> lfPatterns = new ArrayList<String>();
            ArrayList<String> crlfPatterns = new ArrayList<String>();
            ArrayList<String> nativePatterns = new ArrayList<String>();
            ArrayList<String> binPatterns = new ArrayList<String>();
            for (Map.Entry<String, String> e : hgeol.getSection("patterns").entrySet()) {
                if ("CRLF".equals(e.getValue())) {
                    crlfPatterns.add(e.getKey());
                    continue;
                }
                if ("LF".equals(e.getValue())) {
                    lfPatterns.add(e.getKey());
                    continue;
                }
                if ("native".equals(e.getValue())) {
                    nativePatterns.add(e.getKey());
                    continue;
                }
                if ("BIN".equals(e.getValue())) {
                    binPatterns.add(e.getKey());
                    continue;
                }
                hgRepo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Can't recognize .hgeol entry: %s for %s", e.getValue(), e.getKey());
            }
            if (!crlfPatterns.isEmpty()) {
                this.crlfMatcher = new PathGlobMatcher(crlfPatterns.toArray(new String[crlfPatterns.size()]));
            }
            if (!lfPatterns.isEmpty()) {
                this.lfMatcher = new PathGlobMatcher(lfPatterns.toArray(new String[lfPatterns.size()]));
            }
            if (!binPatterns.isEmpty()) {
                this.binMatcher = new PathGlobMatcher(binPatterns.toArray(new String[binPatterns.size()]));
            }
            if (!nativePatterns.isEmpty()) {
                this.nativeMatcher = new PathGlobMatcher(nativePatterns.toArray(new String[nativePatterns.size()]));
            }
        }

        @Override
        public Filter create(Path path, Filter.Options opts) {
            if (this.binMatcher == null && this.crlfMatcher == null && this.lfMatcher == null && this.nativeMatcher == null) {
                return null;
            }
            if (this.binMatcher != null && this.binMatcher.accept(path)) {
                return null;
            }
            if (this.crlfMatcher != null && this.crlfMatcher.accept(path)) {
                return new NewlineFilter(this.processOnlyConsistent, 1, null);
            }
            if (this.lfMatcher != null && this.lfMatcher.accept(path)) {
                return new NewlineFilter(this.processOnlyConsistent, 0, null);
            }
            if (this.nativeMatcher != null && this.nativeMatcher.accept(path)) {
                if (this.nativeOSFormat.equals(this.nativeRepoFormat)) {
                    return null;
                }
                if (opts.getDirection() == Filter.Direction.FromRepo) {
                    int transform = "CRLF".equals(this.nativeOSFormat) ? 1 : 0;
                    return new NewlineFilter(this.processOnlyConsistent, transform, null);
                }
                if (opts.getDirection() == Filter.Direction.ToRepo) {
                    int transform = "CRLF".equals(this.nativeOSFormat) ? 0 : 1;
                    return new NewlineFilter(this.processOnlyConsistent, transform, null);
                }
                return null;
            }
            return null;
        }
    }
}

