/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.IntVector;

public final class Patch {
    private final IntVector starts;
    private final IntVector ends;
    private final ArrayList<byte[]> data;
    private final boolean shallNormalize;

    private static byte[] generate(int c) {
        byte[] rv = new byte[c];
        int i = 0;
        while (i < c) {
            byte x;
            rv[i] = x = (byte)(97 + i);
            ++i;
        }
        return rv;
    }

    public static void main(String[] args) {
        Patch p1 = new Patch();
        Patch p2 = new Patch();
        p1.add(15, 25, Patch.generate(10));
        p2.add(10, 30, Patch.generate(20));
        System.out.println("p1: " + p1);
        System.out.println("p2: " + p2);
        Patch r = p1.apply(p2);
        System.out.println("r: " + r);
    }

    public Patch() {
        this(16, false);
    }

    public Patch(boolean normalizeOnChange) {
        this(16, normalizeOnChange);
    }

    public Patch(int sizeHint, boolean normalizeOnChange) {
        this.shallNormalize = normalizeOnChange;
        this.starts = new IntVector(sizeHint, -1);
        this.ends = new IntVector(sizeHint, -1);
        this.data = new ArrayList(sizeHint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        int i = 0;
        while (i < this.count()) {
            f.format("[%d, %d, %d] ", this.starts.get(i), this.ends.get(i), this.data.get(i).length);
            ++i;
        }
        return sb.toString();
    }

    public int count() {
        return this.data.size();
    }

    public int patchSizeDelta() {
        int rv = 0;
        int prevEnd = 0;
        int i = 0;
        int x = this.data.size();
        while (i < x) {
            int start = this.starts.get(i);
            int len = this.data.get(i).length;
            rv += start - prevEnd;
            rv += len;
            prevEnd = this.ends.get(i);
            ++i;
        }
        return rv -= prevEnd;
    }

    public byte[] apply(DataAccess baseRevisionContent, int outcomeLen) throws IOException {
        if (outcomeLen == -1) {
            outcomeLen = baseRevisionContent.length() + this.patchSizeDelta();
        }
        int prevEnd = 0;
        int destIndex = 0;
        byte[] rv = new byte[outcomeLen];
        int i = 0;
        int x = this.data.size();
        while (i < x) {
            int start = this.starts.get(i);
            baseRevisionContent.seek(prevEnd);
            baseRevisionContent.readBytes(rv, destIndex, start - prevEnd);
            byte[] d = this.data.get(i);
            System.arraycopy(d, 0, rv, destIndex += start - prevEnd, d.length);
            destIndex += d.length;
            prevEnd = this.ends.get(i);
            ++i;
        }
        baseRevisionContent.seek(prevEnd);
        baseRevisionContent.readBytes(rv, destIndex, baseRevisionContent.length() - prevEnd);
        return rv;
    }

    public void clear() {
        this.starts.clear();
        this.ends.clear();
        this.data.clear();
    }

    public void read(DataAccess da) throws IOException {
        this.clear();
        while (!da.isEmpty()) {
            this.readOne(da);
        }
    }

    public void readOne(DataAccess da) throws IOException {
        int s = da.readInt();
        int e = da.readInt();
        int len = da.readInt();
        byte[] src = new byte[len];
        da.readBytes(src, 0, len);
        this.starts.add(s);
        this.ends.add(e);
        this.data.add(src);
    }

    public int serializedLength() {
        int totalDataLen = 0;
        for (byte[] d : this.data) {
            totalDataLen += d.length;
        }
        int prefix = 12 * this.count();
        return prefix + totalDataLen;
    }

    void serialize(DataSerializer out) throws HgIOException {
        int i = 0;
        int x = this.data.size();
        while (i < x) {
            int start = this.starts.get(i);
            int end = this.ends.get(i);
            byte[] d = this.data.get(i);
            out.writeInt(start, end, d.length);
            out.write(d, 0, d.length);
            ++i;
        }
    }

    private void add(Patch p, int i) {
        this.add(p.starts.get(i), p.ends.get(i), p.data.get(i));
    }

    void add(int start, int end, byte[] d) {
        int last;
        if (start == end && d.length == 0) {
            System.currentTimeMillis();
            return;
        }
        if (this.shallNormalize && (last = this.starts.size()) > 0 && this.ends.get(--last) == start) {
            byte[] nd;
            byte[] d1 = this.data.get(last);
            if (d1.length > 0 && d.length > 0) {
                nd = new byte[d1.length + d.length];
                System.arraycopy(d1, 0, nd, 0, d1.length);
                System.arraycopy(d, 0, nd, d1.length, d.length);
            } else {
                nd = d1.length == 0 ? d : d1;
            }
            this.ends.set(last, end);
            this.data.set(last, nd);
            return;
        }
        this.starts.add(start);
        this.ends.add(end);
        this.data.add(d);
    }

    private static byte[] subarray(byte[] d, int start, int end) {
        byte[] r = new byte[end - start];
        System.arraycopy(d, start, r, 0, r.length);
        return r;
    }

    public Patch apply(Patch another) {
        Patch r = new Patch(this.count() + another.count() * 2, this.shallNormalize);
        int p1TotalAppliedDelta = 0;
        int p1EntryStart = 0;
        int p1EntryEnd = 0;
        int p1EntryLen = 0;
        byte[] p1Data = null;
        boolean insideP1entry = false;
        int p2 = 0;
        int p1 = 0;
        int p2Max = another.count();
        int p1Max = this.count();
        while (p2 < p2Max) {
            block21: {
                int p2EntryStart = another.starts.get(p2);
                int p2EntryEnd = another.ends.get(p2);
                int p2EntryRange = p2EntryEnd - p2EntryStart;
                byte[] p2Data = another.data.get(p2);
                boolean insideP2entry = false;
                int p2EntrySavedStart = -1;
                while (p1 < p1Max) {
                    if (!insideP1entry) {
                        p1EntryStart = this.starts.get(p1);
                        p1EntryEnd = this.ends.get(p1);
                        p1Data = this.data.get(p1);
                        p1EntryLen = p1Data.length;
                    }
                    int p1EntryDelta = p1EntryLen - (p1EntryEnd - p1EntryStart);
                    int p1EntryAppliedStart = p1TotalAppliedDelta + p1EntryStart;
                    int p1EntryAppliedEnd = p1EntryAppliedStart + p1EntryLen;
                    if (insideP2entry) {
                        if (p2EntryEnd <= p1EntryAppliedStart) {
                            r.add(p2EntrySavedStart, p2EntryEnd - p1TotalAppliedDelta, p2Data);
                            insideP2entry = false;
                        } else {
                            if (p2EntryEnd >= p1EntryAppliedEnd) {
                                insideP1entry = false;
                                ++p1;
                                p1TotalAppliedDelta += p1EntryDelta;
                                continue;
                            }
                            r.add(p2EntrySavedStart, p1EntryStart, p2Data);
                            int p1DataPartShift = p2EntryEnd - p1EntryAppliedStart;
                            assert (p1DataPartShift < p1EntryLen);
                            p1EntryLen -= p1DataPartShift;
                            p1Data = Patch.subarray(p1Data, p1DataPartShift, p1Data.length);
                            p1TotalAppliedDelta += p1DataPartShift;
                            insideP1entry = true;
                            insideP2entry = false;
                        }
                        break block21;
                    }
                    if (p1EntryAppliedStart < p2EntryStart) {
                        if (p1EntryAppliedEnd <= p2EntryStart) {
                            r.add(p1EntryStart, p1EntryEnd, p1Data);
                            insideP1entry = false;
                            ++p1;
                        } else {
                            int p1DataPartEnd = p2EntryStart - p1EntryAppliedStart;
                            assert (p1DataPartEnd < p1EntryLen);
                            r.add(p1EntryStart, p1EntryEnd, Patch.subarray(p1Data, 0, p1DataPartEnd));
                            if (p2EntryEnd <= p1EntryAppliedEnd) {
                                r.add(p1EntryEnd, p1EntryEnd, p2Data);
                                insideP1entry = true;
                                p1EntryStart = p1EntryEnd;
                                p1EntryLen -= p1DataPartEnd;
                                assert ((p1EntryLen -= p2EntryRange) >= 0);
                                p1Data = Patch.subarray(p1Data, p1DataPartEnd + p2EntryRange, p1Data.length);
                                p1TotalAppliedDelta += p1EntryDelta - p1EntryLen;
                                break block21;
                            }
                            insideP1entry = false;
                            ++p1;
                            insideP2entry = true;
                            p2EntrySavedStart = p1EntryEnd;
                        }
                    } else {
                        if (p2EntryEnd < p1EntryAppliedStart) {
                            r.add(p2EntryStart - p1TotalAppliedDelta, p2EntryEnd - p1TotalAppliedDelta, p2Data);
                            break block21;
                        }
                        int p2DataPartEnd = p1EntryAppliedStart - p2EntryStart;
                        if (p2EntryEnd < p1EntryAppliedEnd) {
                            insideP1entry = true;
                            r.add(p1EntryStart - p2DataPartEnd, p1EntryEnd, p2Data);
                            p1EntryStart = p1EntryEnd;
                            int p1DataPartEnd = p2EntryEnd - p1EntryAppliedStart;
                            assert (p1DataPartEnd < p1EntryLen);
                            assert (p1DataPartEnd >= 0);
                            p1Data = Patch.subarray(p1Data, p1DataPartEnd, p1Data.length);
                            p1TotalAppliedDelta += p1EntryDelta - (p1EntryLen -= p1DataPartEnd);
                            break block21;
                        }
                        insideP1entry = false;
                        ++p1;
                        insideP2entry = true;
                        p2EntrySavedStart = p1EntryStart - p2DataPartEnd;
                    }
                    p1TotalAppliedDelta += p1EntryDelta;
                }
                int s = p2EntrySavedStart != -1 ? p2EntrySavedStart : p2EntryStart - p1TotalAppliedDelta;
                r.add(s, p2EntryEnd - p1TotalAppliedDelta, p2Data);
            }
            ++p2;
        }
        if (p1 < p1Max && insideP1entry) {
            r.add(p1EntryStart, p1EntryEnd, p1Data);
            ++p1;
        }
        while (p1 < p1Max) {
            r.add(this, p1);
            ++p1;
        }
        return r;
    }

    public Patch normalize() {
        Patch rv = null;
        int i = 1;
        int x = this.data.size();
        while (i < x) {
            if (this.starts.get(i) == this.ends.get(i - 1)) {
                byte[] nd;
                if (rv == null) {
                    rv = new Patch();
                    rv.copyOf(this, 0, i - 1);
                }
                byte[] d1 = this.data.get(i - 1);
                byte[] d = this.data.get(i);
                if (d1.length > 0 && d.length > 0) {
                    nd = new byte[d1.length + d.length];
                    System.arraycopy(d1, 0, nd, 0, d1.length);
                    System.arraycopy(d, 0, nd, d1.length, d.length);
                } else {
                    nd = d1.length == 0 ? d : d1;
                }
                rv.add(this.starts.get(i - 1), this.ends.get(i), nd);
                ++i;
            } else if (rv != null) {
                rv.add(this, i - 1);
            }
            ++i;
        }
        if (rv == null) {
            return this;
        }
        int last = this.count() - 1;
        if (this.starts.get(last) != this.ends.get(last - 1)) {
            rv.add(this, last);
        }
        return rv;
    }

    private void copyOf(Patch another, int fromIndex, int upToIndex) {
        while (fromIndex < upToIndex) {
            this.add(another, fromIndex++);
        }
    }

    public class PatchDataSource
    implements DataSerializer.DataSource {
        @Override
        public void serialize(DataSerializer out) throws HgIOException {
            Patch.this.serialize(out);
        }

        @Override
        public int serializeLength() {
            return Patch.this.serializedLength();
        }
    }
}

