/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.regex.PatternSyntaxException;
import org.tmatesoft.hg.internal.PathRegexpMatcher;
import org.tmatesoft.hg.util.Path;

public class PathGlobMatcher
implements Path.Matcher {
    private final PathRegexpMatcher delegate;

    public PathGlobMatcher(String ... globPatterns) {
        String[] regexp = new String[globPatterns.length];
        int i = 0;
        String[] stringArray = globPatterns;
        int n = globPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            regexp[i++] = PathGlobMatcher.glob2regexp(s);
            ++n2;
        }
        try {
            this.delegate = new PathRegexpMatcher(regexp);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String glob2regexp(String glob) {
        int end = glob.length() - 1;
        if (glob.length() > 2 && glob.charAt(end) == '*' && glob.charAt(end - 1) == '.') {
            end -= 2;
        }
        boolean needLineEndMatch = true;
        StringBuilder sb = new StringBuilder(end * 2);
        sb.append('^');
        int i = 0;
        while (i <= end) {
            char ch = glob.charAt(i);
            if (ch == '*') {
                if (i < end && glob.charAt(i + 1) == '*') {
                    sb.append(".*?");
                    if (++i < end && glob.charAt(i + 1) == '/') {
                        sb.append("/?");
                        ++i;
                    }
                } else {
                    sb.append("[^/]*?");
                }
            } else if (ch == '?') {
                sb.append("[^/]");
            } else {
                if (ch == '.' || ch == '\\') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            ++i;
        }
        if (needLineEndMatch) {
            sb.append('$');
        }
        return sb.toString();
    }

    @Override
    public boolean accept(Path path) {
        return this.delegate.accept(path);
    }
}

