/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.lang.ref.SoftReference;
import java.util.WeakHashMap;
import org.tmatesoft.hg.util.Convertor;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class PathPool
implements Path.Source,
Convertor<Path> {
    private final WeakHashMap<CharSequence, SoftReference<Path>> cache;
    private final PathRewrite pathRewrite;

    public PathPool(PathRewrite rewrite) {
        this.pathRewrite = rewrite;
        this.cache = new WeakHashMap();
    }

    @Override
    public Path path(CharSequence p) {
        if (p instanceof Path) {
            return this.asPath((Path)p);
        }
        p = this.pathRewrite.rewrite(p);
        return this.get(p, true);
    }

    @Override
    public Path mangle(Path p) {
        return this.asPath(p);
    }

    private Path asPath(Path p) {
        CharSequence s = this.pathRewrite.rewrite(p.toString());
        Path cached = this.get(s, false);
        if (cached == null) {
            cached = p;
            this.cache.put(s, new SoftReference<Path>(cached));
        }
        return cached;
    }

    public Path parent(Path path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException();
        }
        int i = path.length() - 2;
        while (i >= 0) {
            if (path.charAt(i) == '/') {
                return this.get(path.subSequence(0, i + 1).toString(), true);
            }
            --i;
        }
        return this.get("", true);
    }

    public void clear() {
        this.cache.clear();
    }

    private Path get(CharSequence p, boolean create) {
        Path path;
        SoftReference<Path> sr = this.cache.get(p);
        Path path2 = path = sr == null ? null : sr.get();
        if (path == null) {
            if (create) {
                path = Path.create(p);
                this.cache.put(p, new SoftReference<Path>(path));
            } else if (sr != null) {
                this.cache.remove(p);
            }
        }
        return path;
    }
}

