/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import org.tmatesoft.hg.util.Path;

public class PathScope
implements Path.Matcher {
    private final Path[] files;
    private final Path[] dirs;
    private final boolean includeNestedDirs;
    private final boolean includeParentDirs;
    private final boolean includeDirContent;

    public PathScope(boolean recursiveDirs, Path ... paths) {
        this(true, recursiveDirs, true, paths);
    }

    public PathScope(boolean matchParentDirs, boolean recursiveDirs, boolean matchDirContent, Path ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException();
        }
        this.includeParentDirs = matchParentDirs;
        this.includeNestedDirs = recursiveDirs;
        this.includeDirContent = matchDirContent;
        ArrayList<Path> f = new ArrayList<Path>(5);
        ArrayList<Path> d = new ArrayList<Path>(5);
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            if (p.isDirectory()) {
                d.add(p);
            } else {
                f.add(p);
            }
            ++n2;
        }
        this.files = f.toArray(new Path[f.size()]);
        this.dirs = d.toArray(new Path[d.size()]);
    }

    @Override
    public boolean accept(Path path) {
        if (path.isDirectory()) {
            Path[] pathArray = this.dirs;
            int n = this.dirs.length;
            int n2 = 0;
            while (n2 < n) {
                Path d = pathArray[n2];
                switch (d.compareWith(path)) {
                    case Same: {
                        return true;
                    }
                    case ImmediateChild: 
                    case Nested: {
                        return this.includeParentDirs;
                    }
                    case ImmediateParent: 
                    case Parent: {
                        return this.includeNestedDirs;
                    }
                }
                ++n2;
            }
            if (!this.includeParentDirs) {
                return false;
            }
            pathArray = this.files;
            n = this.files.length;
            n2 = 0;
            while (n2 < n) {
                Path f = pathArray[n2];
                Path.CompareResult cr = f.compareWith(path);
                if (cr == Path.CompareResult.Nested || cr == Path.CompareResult.ImmediateChild) {
                    return true;
                }
                ++n2;
            }
        } else {
            Path[] pathArray = this.files;
            int n = this.files.length;
            int n3 = 0;
            while (n3 < n) {
                Path f = pathArray[n3];
                if (f.equals(path)) {
                    return true;
                }
                ++n3;
            }
            if (!this.includeNestedDirs && !this.includeDirContent) {
                return false;
            }
            pathArray = this.dirs;
            n = this.dirs.length;
            n3 = 0;
            while (n3 < n) {
                Path d = pathArray[n3];
                Path.CompareResult cr = d.compareWith(path);
                if (this.includeNestedDirs && cr == Path.CompareResult.Parent) {
                    return true;
                }
                if (this.includeDirContent && cr == Path.CompareResult.ImmediateParent) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }
}

