/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.LineReader;
import org.tmatesoft.hg.internal.RevisionDescendants;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgPhase;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public final class PhasesHelper {
    private final Internals repo;
    private final HgParentChildMap<HgChangelog> parentHelper;
    private Boolean repoSupporsPhases;
    private List<Nodeid> draftPhaseRoots;
    private List<Nodeid> secretPhaseRoots;
    private RevisionDescendants[][] phaseDescendants = new RevisionDescendants[HgPhase.values().length][];

    public PhasesHelper(Internals internalRepo) {
        this(internalRepo, null);
    }

    public PhasesHelper(Internals internalRepo, HgParentChildMap<HgChangelog> pw) {
        this.repo = internalRepo;
        this.parentHelper = pw;
    }

    public HgRepository getRepo() {
        return this.repo.getRepo();
    }

    public boolean isCapableOfPhases() throws HgRuntimeException {
        if (this.repoSupporsPhases == null) {
            this.repoSupporsPhases = this.readRoots();
        }
        return this.repoSupporsPhases;
    }

    public boolean withSecretRoots() {
        return !this.secretPhaseRoots.isEmpty();
    }

    public HgPhase getPhase(HgChangeset cset) throws HgRuntimeException {
        Nodeid csetRev = cset.getNodeid();
        int csetRevIndex = cset.getRevisionIndex();
        return this.getPhase(csetRevIndex, csetRev);
    }

    public HgPhase getPhase(int csetRevIndex, Nodeid csetRev) throws HgRuntimeException {
        if (!this.isCapableOfPhases()) {
            return HgPhase.Undefined;
        }
        if (this.parentHelper != null && (csetRev == null || csetRev.isNull())) {
            csetRev = this.getRepo().getChangelog().getRevision(csetRevIndex);
        }
        HgPhase[] hgPhaseArray = new HgPhase[]{HgPhase.Secret, HgPhase.Draft};
        int n = hgPhaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            HgPhase phase = hgPhaseArray[n2];
            List<Nodeid> roots = this.getPhaseRoots(phase);
            if (!roots.isEmpty()) {
                if (this.parentHelper != null) {
                    if (roots.contains(csetRev)) {
                        return phase;
                    }
                    if (this.parentHelper.childrenOf(roots).contains(csetRev)) {
                        return phase;
                    }
                } else {
                    RevisionDescendants[] revisionDescendantsArray = this.getPhaseDescendants(phase);
                    int n3 = revisionDescendantsArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        RevisionDescendants rd = revisionDescendantsArray[n4];
                        if (rd.isCandidate(csetRevIndex) && rd.isDescendant(csetRevIndex)) {
                            return phase;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return HgPhase.Public;
    }

    public RevisionSet allSecret() {
        return this.allOf(HgPhase.Secret);
    }

    public RevisionSet allDraft() {
        return this.allOf(HgPhase.Draft).subtract(this.allOf(HgPhase.Secret));
    }

    public void updateRoots(Collection<Nodeid> draftRoots, Collection<Nodeid> secretRoots) throws HgInvalidControlFileException {
        this.draftPhaseRoots = draftRoots.isEmpty() ? Collections.emptyList() : new ArrayList<Nodeid>(draftRoots);
        this.secretPhaseRoots = secretRoots.isEmpty() ? Collections.emptyList() : new ArrayList<Nodeid>(secretRoots);
        String fmt = "%d %s\n";
        File phaseroots = this.repo.getRepositoryFile(HgRepositoryFiles.Phaseroots);
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(phaseroots);
                for (Nodeid n : this.secretPhaseRoots) {
                    fw.write(String.format(fmt, HgPhase.Secret.mercurialOrdinal(), n.toString()));
                }
                for (Nodeid n : this.draftPhaseRoots) {
                    fw.write(String.format(fmt, HgPhase.Draft.mercurialOrdinal(), n.toString()));
                }
                fw.flush();
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException(ex.getMessage(), ex, phaseroots);
            }
        }
        finally {
            new FileUtils(this.repo.getLog(), this).closeQuietly(fw);
        }
    }

    public void newCommitNode(Nodeid newChangeset, HgPhase newCommitPhase) throws HgRuntimeException {
        int riCset = this.repo.getRepo().getChangelog().getRevisionIndex(newChangeset);
        HgPhase ph = this.getPhase(riCset, newChangeset);
        if (ph.compareTo(newCommitPhase) >= 0) {
            return;
        }
        assert (newCommitPhase != HgPhase.Public);
        RevisionSet rs = this.allOf(newCommitPhase).union(new RevisionSet(Collections.singleton(newChangeset)));
        RevisionSet newRoots = this.parentHelper != null ? rs.roots(this.parentHelper) : rs.roots(this.repo.getRepo());
        if (newCommitPhase == HgPhase.Draft) {
            this.updateRoots(newRoots.asList(), this.secretPhaseRoots);
        } else if (newCommitPhase == HgPhase.Secret) {
            this.updateRoots(this.draftPhaseRoots, newRoots.asList());
        } else {
            throw new HgInvalidStateException(String.format("Unexpected phase %s for new commits", new Object[]{newCommitPhase}));
        }
    }

    public RevisionSet synchronizeWithRemote(HgRemoteRepository.Phases remotePhases, RevisionSet sharedWithRemote) throws HgInvalidControlFileException {
        RevisionSet secretLeft;
        RevisionSet draftLeft;
        assert (this.parentHelper != null);
        RevisionSet presentSecret = this.allSecret();
        RevisionSet presentDraft = this.allDraft();
        RevisionSet remoteDrafts = this.knownRemoteDrafts(remotePhases, sharedWithRemote, presentSecret);
        if (remotePhases.isPublishingServer()) {
            RevisionSet draftsBecomePublic = presentDraft.intersect(sharedWithRemote);
            RevisionSet secretsBecomePublic = presentSecret.intersect(sharedWithRemote);
            RevisionSet draftsGone = presentDraft.ancestors(draftsBecomePublic, this.parentHelper);
            RevisionSet secretsGone = presentSecret.ancestors(secretsBecomePublic, this.parentHelper);
            draftLeft = presentDraft.subtract(draftsGone).subtract(draftsBecomePublic);
            secretLeft = presentSecret.subtract(secretsGone).subtract(secretsBecomePublic);
        } else {
            RevisionSet secretGone = presentSecret.intersect(remoteDrafts);
            RevisionSet remotePublic = presentSecret.ancestors(secretGone, this.parentHelper);
            secretLeft = presentSecret.subtract(secretGone).subtract(remotePublic);
            RevisionSet sharedDraft = presentDraft.intersect(remoteDrafts);
            RevisionSet localDraftRemotePublic = presentDraft.ancestors(sharedDraft, this.parentHelper);
            RevisionSet remoteDraftsLocalPublic = remoteDrafts.ancestors(sharedDraft, this.parentHelper);
            RevisionSet remoteDraftsLeft = remoteDrafts.subtract(remoteDraftsLocalPublic);
            RevisionSet combinedDraft = presentDraft.union(remoteDraftsLeft);
            draftLeft = combinedDraft.subtract(localDraftRemotePublic);
        }
        RevisionSet newDraftRoots = draftLeft.roots(this.parentHelper);
        RevisionSet newSecretRoots = secretLeft.roots(this.parentHelper);
        this.updateRoots(newDraftRoots.asList(), newSecretRoots.asList());
        RevisionSet remoteDraftsLocalPublic = remoteDrafts.subtract(draftLeft).subtract(secretLeft);
        return remoteDraftsLocalPublic;
    }

    private RevisionSet knownRemoteDrafts(HgRemoteRepository.Phases remotePhases, RevisionSet shared, RevisionSet localSecret) {
        ArrayList<Nodeid> knownRemoteDraftRoots = new ArrayList<Nodeid>();
        for (Nodeid rdr : remotePhases.draftRoots()) {
            if (!this.parentHelper.knownNode(rdr)) continue;
            knownRemoteDraftRoots.add(rdr);
        }
        RevisionSet remoteDrafts = new RevisionSet(knownRemoteDraftRoots);
        RevisionSet localChildren = remoteDrafts.children(this.parentHelper);
        localChildren = localChildren.subtract(localSecret);
        remoteDrafts = remoteDrafts.union(localChildren);
        RevisionSet localChildrenNotSent = shared.children(this.parentHelper).subtract(shared);
        remoteDrafts = remoteDrafts.subtract(localChildrenNotSent);
        return remoteDrafts;
    }

    private RevisionSet allOf(HgPhase phase) {
        assert (phase != HgPhase.Public);
        if (!this.isCapableOfPhases()) {
            return new RevisionSet(Collections.emptyList());
        }
        List<Nodeid> roots = this.getPhaseRoots(phase);
        if (this.parentHelper != null) {
            return new RevisionSet(roots).union(new RevisionSet(this.parentHelper.childrenOf(roots)));
        }
        RevisionSet rv = new RevisionSet(Collections.emptyList());
        RevisionDescendants[] revisionDescendantsArray = this.getPhaseDescendants(phase);
        int n = revisionDescendantsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevisionDescendants rd = revisionDescendantsArray[n2];
            rv = rv.union(rd.asRevisionSet());
            ++n2;
        }
        return rv;
    }

    private Boolean readRoots() throws HgRuntimeException {
        File phaseroots = this.repo.getRepositoryFile(HgRepositoryFiles.Phaseroots);
        try {
            if (!phaseroots.exists()) {
                if (this.repo.shallCreatePhaseroots()) {
                    this.draftPhaseRoots = Collections.emptyList();
                    this.secretPhaseRoots = Collections.emptyList();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            LineReader lr = new LineReader(phaseroots, this.repo.getLog());
            Collection lines = lr.read(new LineReader.SimpleLineCollector(), new LinkedList());
            HashMap<HgPhase, LinkedList<Nodeid>> phase2roots = new HashMap<HgPhase, LinkedList<Nodeid>>();
            for (String line : lines) {
                String[] lc = line.split("\\s+");
                if (lc.length == 0) continue;
                if (lc.length != 2) {
                    this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Bad line in phaseroots:%s", line);
                    continue;
                }
                int phaseIndex = Integer.parseInt(lc[0]);
                Nodeid rootRev = Nodeid.fromAscii(lc[1]);
                if (!this.getRepo().getChangelog().isKnown(rootRev)) {
                    this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Phase(%d) root node %s doesn't exist in the repository, ignored.", phaseIndex, rootRev);
                    continue;
                }
                HgPhase phase = HgPhase.parse(phaseIndex);
                LinkedList<Nodeid> roots = (LinkedList<Nodeid>)phase2roots.get((Object)phase);
                if (roots == null) {
                    roots = new LinkedList<Nodeid>();
                    phase2roots.put(phase, roots);
                }
                roots.add(rootRev);
            }
            this.draftPhaseRoots = phase2roots.containsKey((Object)HgPhase.Draft) ? (List)phase2roots.get((Object)HgPhase.Draft) : Collections.emptyList();
            this.secretPhaseRoots = phase2roots.containsKey((Object)HgPhase.Secret) ? (List)phase2roots.get((Object)HgPhase.Secret) : Collections.emptyList();
        }
        catch (HgIOException ex) {
            throw new HgInvalidControlFileException(ex, true);
        }
        return Boolean.TRUE;
    }

    private List<Nodeid> getPhaseRoots(HgPhase phase) {
        switch (phase) {
            case Draft: {
                return this.draftPhaseRoots;
            }
            case Secret: {
                return this.secretPhaseRoots;
            }
        }
        return Collections.emptyList();
    }

    private RevisionDescendants[] getPhaseDescendants(HgPhase phase) throws HgRuntimeException {
        int ordinal = phase.ordinal();
        if (this.phaseDescendants[ordinal] == null) {
            this.phaseDescendants[ordinal] = this.buildPhaseDescendants(phase);
        }
        return this.phaseDescendants[ordinal];
    }

    private RevisionDescendants[] buildPhaseDescendants(HgPhase phase) throws HgRuntimeException {
        int[] roots = this.toIndexes(this.getPhaseRoots(phase));
        RevisionDescendants[] rv = new RevisionDescendants[roots.length];
        int i = 0;
        while (i < roots.length) {
            rv[i] = new RevisionDescendants(this.getRepo(), roots[i]);
            rv[i].build();
            ++i;
        }
        return rv;
    }

    private int[] toIndexes(List<Nodeid> roots) throws HgRuntimeException {
        int[] rv = new int[roots.size()];
        int i = 0;
        while (i < rv.length) {
            rv[i] = this.getRepo().getChangelog().getRevisionIndex(roots.get(i));
            ++i;
        }
        return rv;
    }
}

