/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.HashMap;
import org.tmatesoft.hg.util.Convertor;

public class Pool<T>
implements Convertor<T> {
    private final HashMap<T, T> unify;

    public Pool() {
        this.unify = new HashMap();
    }

    public Pool(int sizeHint) {
        this.unify = sizeHint <= 0 ? new HashMap() : new HashMap(sizeHint * 4 / 3, 0.75f);
    }

    @Override
    public T mangle(T t) {
        return this.unify(t);
    }

    public T unify(T t) {
        T rv = this.unify.get(t);
        if (rv == null) {
            this.unify.put(t, t);
            rv = t;
        }
        return rv;
    }

    public boolean contains(T t) {
        return this.unify.containsKey(t);
    }

    public void record(T t) {
        this.unify.put(t, t);
    }

    public void clear() {
        this.unify.clear();
    }

    public int size() {
        return this.unify.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Pool.class.getSimpleName());
        sb.append('<');
        if (!this.unify.isEmpty()) {
            sb.append(this.unify.keySet().iterator().next().getClass().getName());
        }
        sb.append('>');
        sb.append(':');
        sb.append(this.unify.size());
        return sb.toString();
    }
}

