/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Formatter;
import org.tmatesoft.hg.internal.IntSliceSeq;
import org.tmatesoft.hg.internal.IntTuple;

public final class RangePairSeq {
    private final IntSliceSeq ranges = new IntSliceSeq(3);

    public void add(int start1, int start2, int length) {
        int count = this.ranges.size();
        if (count > 0) {
            int lastS1 = this.ranges.get(--count, 0);
            int lastS2 = this.ranges.get(count, 1);
            int lastLen = this.ranges.get(count, 2);
            if (start1 == lastS1 + lastLen && start2 == lastS2 + lastLen) {
                this.ranges.set(count, lastS1, lastS2, lastLen + length);
                return;
            }
        }
        this.ranges.add(start1, start2, length);
    }

    public void clear() {
        this.ranges.clear();
    }

    public int size() {
        return this.ranges.size();
    }

    public int mapLineIndex(int ln) {
        for (IntTuple t : this.ranges) {
            int s1 = t.at(0);
            if (s1 > ln) {
                return -1;
            }
            int l = t.at(2);
            if (s1 + l <= ln) continue;
            int s2 = t.at(1);
            return s2 + (ln - s1);
        }
        return -1;
    }

    public int reverseMapLine(int targetLine) {
        for (IntTuple t : this.ranges) {
            int ts = t.at(1);
            if (ts > targetLine) {
                return -1;
            }
            int l = t.at(2);
            if (ts + l <= targetLine) continue;
            int os = t.at(0);
            return os + (targetLine - ts);
        }
        return -1;
    }

    public RangePairSeq intersect(RangePairSeq target) {
        RangePairSeq v = new RangePairSeq();
        for (IntTuple t : this.ranges) {
            int originLine = t.at(0);
            int targetLine = t.at(1);
            int length = t.at(2);
            int startTargetLine = -1;
            int startOriginLine = -1;
            int c = 0;
            int j = 0;
            while (j < length) {
                block11: {
                    int lnInFinal;
                    block10: {
                        lnInFinal = target.mapLineIndex(targetLine + j);
                        if (lnInFinal != -1 && (startTargetLine == -1 || lnInFinal == startTargetLine + c)) break block10;
                        if (startOriginLine == -1) break block11;
                        v.add(startOriginLine, startTargetLine, c);
                        c = 0;
                        startTargetLine = -1;
                        startOriginLine = -1;
                    }
                    if (lnInFinal != -1) {
                        if (startOriginLine == -1) {
                            startOriginLine = originLine + j;
                            startTargetLine = lnInFinal;
                            c = 1;
                        } else {
                            assert (lnInFinal == startTargetLine + c);
                            ++c;
                        }
                    }
                }
                ++j;
            }
            if (startOriginLine == -1) continue;
            assert (c > 0);
            v.add(startOriginLine, startTargetLine, c);
        }
        return v;
    }

    public boolean includesOriginLine(int ln) {
        return this.includes(ln, 0);
    }

    public boolean includesTargetLine(int ln) {
        return this.includes(ln, 1);
    }

    private boolean includes(int ln, int o) {
        for (IntTuple t : this.ranges) {
            int rangeStart = t.at(o);
            if (rangeStart > ln) {
                return false;
            }
            int rangeLen = t.at(2);
            if (rangeStart + rangeLen <= ln) continue;
            return true;
        }
        return false;
    }

    public CharSequence dump() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        for (IntTuple t : this.ranges) {
            int s1 = t.at(0);
            int s2 = t.at(1);
            int len = t.at(2);
            f.format("[%d..%d) == [%d..%d);  ", s1, s1 + len, s2, s2 + len);
        }
        return sb;
    }

    public String toString() {
        return String.format("RangeSeq[%d]:%s", this.size(), this.dump());
    }
}

