/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.RequiresFile;
import org.tmatesoft.hg.internal.StoragePathHelper;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.util.PathRewrite;

public class RepoInitializer {
    private int requiresFlags;

    public RepoInitializer initRequiresFromFile(File repoDir) throws HgInvalidControlFileException {
        File requiresFile = new File(repoDir, "requires");
        try {
            int flags = new RequiresFile().parse(requiresFile);
            return this.setRequires(flags);
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Parse failed", ex, requiresFile);
        }
    }

    public RepoInitializer setRequires(int flags) {
        this.requiresFlags = flags;
        return this;
    }

    public int getRequires() {
        return this.requiresFlags;
    }

    public void initEmptyRepository(File repoDir) throws HgIOException {
        repoDir.mkdirs();
        File requiresFile = new File(repoDir, "requires");
        try {
            FileOutputStream requiresStream = new FileOutputStream(requiresFile);
            StringBuilder sb = new StringBuilder(40);
            if ((this.requiresFlags & 0x40000000) != 0) {
                sb.append("revlogv1\n");
            }
            if ((this.requiresFlags & 1) != 0) {
                sb.append("store\n");
            }
            if ((this.requiresFlags & 2) != 0) {
                sb.append("fncache\n");
            }
            if ((this.requiresFlags & 4) != 0) {
                sb.append("dotencode\n");
            }
            requiresStream.write(sb.toString().getBytes());
            requiresStream.close();
        }
        catch (IOException ex) {
            throw new HgIOException("Failed to initialize empty repo", ex, requiresFile);
        }
        if ((this.requiresFlags & 1) != 0) {
            new File(repoDir, "store").mkdir();
        }
    }

    public PathRewrite buildDataFilesHelper(SessionContext ctx) {
        Charset cs = Internals.getFileEncoding(ctx);
        return new StoragePathHelper((this.requiresFlags & 1) != 0, (this.requiresFlags & 2) != 0, (this.requiresFlags & 4) != 0, cs);
    }

    public PathRewrite buildStoreFilesHelper() {
        if ((this.requiresFlags & 1) != 0) {
            return new PathRewrite(){

                @Override
                public CharSequence rewrite(CharSequence path) {
                    return "store/" + path;
                }
            };
        }
        return new PathRewrite.Empty();
    }
}

