/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class RepositoryComparator {
    private final boolean debug = Boolean.parseBoolean(System.getProperty("hg4j.remote.debug"));
    private final HgParentChildMap<HgChangelog> localRepo;
    private final HgRemoteRepository remoteRepo;
    private List<Nodeid> common;
    private List<Nodeid> remoteHeads;

    public RepositoryComparator(HgParentChildMap<HgChangelog> pwLocal, HgRemoteRepository hgRemote) {
        this.localRepo = pwLocal;
        this.remoteRepo = hgRemote;
    }

    public RepositoryComparator compare(ProgressSupport progressSupport, CancelSupport cancelSupport) throws HgRemoteConnectionException, CancelledException {
        cancelSupport.checkCancelled();
        progressSupport.start(10);
        this.common = Collections.unmodifiableList(this.findCommonWithRemote());
        for (Nodeid n : this.common) {
            if (this.localRepo.knownNode(n)) continue;
            throw new HgInvalidStateException("Unknown node reported as common:" + n);
        }
        progressSupport.done();
        return this;
    }

    public List<Nodeid> getCommon() {
        if (this.common == null) {
            throw new HgInvalidStateException("Call #compare(Object) first");
        }
        return this.common;
    }

    public List<Nodeid> getRemoteHeads() {
        assert (this.remoteHeads != null);
        return this.remoteHeads;
    }

    public List<Nodeid> getLocalOnlyRevisions() {
        List<Nodeid> commonChildren;
        RevisionSet rsCommonChildren;
        List<Nodeid> c = this.getCommon();
        if (c.isEmpty()) {
            return this.localRepo.all();
        }
        RevisionSet rsCommon = new RevisionSet(c);
        RevisionSet localHeads = new RevisionSet(this.localRepo.heads());
        RevisionSet headsNotFromCommon = localHeads.subtract(rsCommonChildren = new RevisionSet(commonChildren = this.localRepo.childrenOf(c))).subtract(rsCommon);
        if (headsNotFromCommon.isEmpty()) {
            return commonChildren;
        }
        RevisionSet all = new RevisionSet(this.localRepo.all());
        RevisionSet rsAncestors = all.ancestors(headsNotFromCommon, this.localRepo);
        rsAncestors = rsAncestors.union(headsNotFromCommon);
        RevisionSet rsAncestorsCommon = all.ancestors(rsCommon, this.localRepo);
        RevisionSet outgoing = rsAncestors.subtract(rsAncestorsCommon).subtract(rsCommon);
        return outgoing.union(rsCommonChildren).asList();
    }

    private List<Nodeid> findCommonWithRemote() throws HgRemoteConnectionException {
        this.remoteHeads = this.remoteRepo.heads();
        LinkedList<Nodeid> resultCommon = new LinkedList<Nodeid>();
        LinkedList<Nodeid> toQuery = new LinkedList<Nodeid>();
        for (Nodeid rh : this.remoteHeads) {
            if (this.localRepo.knownNode(rh)) {
                resultCommon.add(rh);
                continue;
            }
            toQuery.add(rh);
        }
        if (toQuery.isEmpty()) {
            return resultCommon;
        }
        LinkedList<HgRemoteRepository.RemoteBranch> checkUp2Head = new LinkedList<HgRemoteRepository.RemoteBranch>();
        while (!toQuery.isEmpty()) {
            List<HgRemoteRepository.RemoteBranch> remoteBranches = this.remoteRepo.branches(toQuery);
            toQuery.clear();
            while (!remoteBranches.isEmpty()) {
                HgRemoteRepository.RemoteBranch rb = remoteBranches.remove(0);
                if (this.localRepo.knownNode(rb.root)) {
                    checkUp2Head.add(rb);
                    continue;
                }
                if (!rb.p1.isNull() && !this.localRepo.knownNode(rb.p1)) {
                    toQuery.add(rb.p1);
                }
                if (rb.p2.isNull() || this.localRepo.knownNode(rb.p2)) continue;
                toQuery.add(rb.p2);
            }
        }
        block3: for (HgRemoteRepository.RemoteBranch rb : checkUp2Head) {
            List<Nodeid> remoteRevisions = this.remoteRepo.between(rb.head, rb.root);
            if (remoteRevisions.isEmpty()) {
                resultCommon.add(rb.root);
                continue;
            }
            Collections.reverse(remoteRevisions);
            Nodeid root = rb.root;
            while (!remoteRevisions.isEmpty()) {
                Nodeid n = remoteRevisions.remove(0);
                if (this.localRepo.knownNode(n)) {
                    if (remoteRevisions.isEmpty()) {
                        resultCommon.add(n);
                        continue block3;
                    }
                    if (remoteRevisions.size() == 1) {
                        Nodeid last = remoteRevisions.remove(0);
                        resultCommon.add(this.localRepo.knownNode(last) ? last : n);
                        continue block3;
                    }
                    root = n;
                    continue;
                }
                remoteRevisions = this.remoteRepo.between(n, root);
                Collections.reverse(remoteRevisions);
                if (!remoteRevisions.isEmpty()) continue;
                resultCommon.add(root);
            }
        }
        return resultCommon;
    }

    public List<BranchChain> calculateMissingBranches() throws HgRemoteConnectionException {
        BranchChain bc;
        List<Nodeid> remoteHeads = this.remoteRepo.heads();
        LinkedList<Nodeid> common = new LinkedList<Nodeid>();
        LinkedHashSet<Nodeid> toQuery = new LinkedHashSet<Nodeid>();
        for (Nodeid rh : remoteHeads) {
            if (this.localRepo.knownNode(rh)) {
                common.add(rh);
                continue;
            }
            toQuery.add(rh);
        }
        if (toQuery.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<BranchChain> branches2load = new LinkedList<BranchChain>();
        LinkedList<HgRemoteRepository.RemoteBranch> checkUp2Head = new LinkedList<HgRemoteRepository.RemoteBranch>();
        HashMap<Nodeid, BranchChain> head2chain = new HashMap<Nodeid, BranchChain>();
        while (!toQuery.isEmpty()) {
            List<HgRemoteRepository.RemoteBranch> remoteBranches = this.remoteRepo.branches(new ArrayList<Nodeid>(toQuery));
            toQuery.clear();
            while (!remoteBranches.isEmpty()) {
                boolean hasP2;
                HgRemoteRepository.RemoteBranch rb = remoteBranches.remove(0);
                BranchChain chainElement = (BranchChain)head2chain.get(rb.head);
                if (chainElement == null) {
                    chainElement = new BranchChain(rb.head);
                    branches2load.add(chainElement);
                    head2chain.put(rb.head, chainElement);
                }
                if (this.localRepo.knownNode(rb.root)) {
                    checkUp2Head.add(rb);
                    continue;
                }
                chainElement.branchRoot = rb.root;
                boolean hasP1 = !rb.p1.isNull();
                boolean bl = hasP2 = !rb.p2.isNull();
                if (hasP1 && !this.localRepo.knownNode(rb.p1)) {
                    toQuery.add(rb.p1);
                    bc = (BranchChain)head2chain.get(rb.p1);
                    if (bc == null) {
                        bc = new BranchChain(rb.p1);
                        head2chain.put(rb.p1, bc);
                    }
                    chainElement.p1 = bc;
                }
                if (hasP2 && !this.localRepo.knownNode(rb.p2)) {
                    toQuery.add(rb.p2);
                    bc = (BranchChain)head2chain.get(rb.p2);
                    if (bc == null) {
                        bc = new BranchChain(rb.p2);
                        head2chain.put(rb.p2, bc);
                    }
                    chainElement.p2 = bc;
                }
                if (hasP1 || hasP2) continue;
                BranchChain fake = new BranchChain(Nodeid.NULL);
                fake.branchRoot = Nodeid.NULL;
                chainElement.p1 = chainElement.p2 = fake;
            }
        }
        for (HgRemoteRepository.RemoteBranch rb : checkUp2Head) {
            Nodeid h = rb.head;
            Nodeid r = rb.root;
            int watchdog = 1000;
            assert (head2chain.containsKey(h));
            bc = (BranchChain)head2chain.get(h);
            assert (bc != null) : h.toString();
            assert (bc.p1 == null);
            assert (bc.p2 == null);
            do {
                List<Nodeid> between;
                if ((between = this.remoteRepo.between(h, r)).isEmpty()) {
                    bc.branchRoot = r;
                    break;
                }
                Collections.reverse(between);
                for (Nodeid n : between) {
                    if (this.localRepo.knownNode(n)) {
                        r = n;
                        continue;
                    }
                    h = n;
                    break;
                }
                Nodeid lastInBetween = between.get(between.size() - 1);
                if (r.equals(lastInBetween)) {
                    bc.branchRoot = r;
                    break;
                }
                if (!h.equals(lastInBetween)) continue;
                bc.branchRoot = r;
                break;
            } while (--watchdog > 0);
            if (watchdog != 0) continue;
            throw new HgInvalidStateException(String.format("Can't narrow down branch [%s, %s]", rb.head.shortNotation(), rb.root.shortNotation()));
        }
        if (this.debug) {
            System.out.println("calculateMissingBranches:");
            for (BranchChain bc2 : branches2load) {
                bc2.dump();
            }
        }
        return branches2load;
    }

    public List<Nodeid> completeBranch(Nodeid branchRoot, Nodeid branchHead) throws HgRemoteConnectionException {
        List<Nodeid> initial = this.remoteRepo.between(branchHead, branchRoot);
        Nodeid[] result = new Nodeid[1 + (1 << initial.size())];
        result[0] = branchHead;
        int rootIndex = -1;
        if (initial.isEmpty()) {
            rootIndex = 1;
        } else if (initial.size() == 1) {
            rootIndex = 2;
        }
        LinkedList<DataEntry> datas = new LinkedList<DataEntry>();
        LinkedList<DataEntry> toQuery = new LinkedList<DataEntry>();
        class DataEntry {
            public final Nodeid queryHead;
            public final int headIndex;
            public List<Nodeid> entries;

            public DataEntry(Nodeid head, int index, List<Nodeid> data) {
                this.queryHead = head;
                this.headIndex = index;
                this.entries = data;
            }
        }
        datas.add(new DataEntry(branchHead, 0, initial));
        int totalQueries = 1;
        HashSet<Nodeid> queried = new HashSet<Nodeid>();
        while (!datas.isEmpty()) {
            HashSet<Nodeid> scheduled = new HashSet<Nodeid>();
            do {
                int idx;
                DataEntry de = (DataEntry)datas.removeFirst();
                int i = 1;
                int j = 0;
                while (j < de.entries.size()) {
                    idx = de.headIndex + i;
                    result[idx] = de.entries.get(j);
                    i <<= 1;
                    ++j;
                }
                if (de.entries.size() <= 1) continue;
                i = 1;
                j = 0;
                while (j < de.entries.size()) {
                    idx = de.headIndex + i;
                    Nodeid x = de.entries.get(j);
                    if (!(queried.contains(x) || scheduled.contains(x) || rootIndex != -1 && rootIndex - de.headIndex <= 1)) {
                        toQuery.add(new DataEntry(x, idx, null));
                        scheduled.add(x);
                    }
                    i <<= 1;
                    ++j;
                }
            } while (!datas.isEmpty());
            if (!toQuery.isEmpty()) {
                ++totalQueries;
            }
            LinkedList<HgRemoteRepository.Range> betweenBatch = new LinkedList<HgRemoteRepository.Range>();
            HashMap<HgRemoteRepository.Range, DataEntry> rangeToEntry = new HashMap<HgRemoteRepository.Range, DataEntry>();
            for (DataEntry de : toQuery) {
                queried.add(de.queryHead);
                HgRemoteRepository.Range r = new HgRemoteRepository.Range(branchRoot, de.queryHead);
                betweenBatch.add(r);
                rangeToEntry.put(r, de);
            }
            if (!betweenBatch.isEmpty()) {
                Map<HgRemoteRepository.Range, List<Nodeid>> between = this.remoteRepo.between(betweenBatch);
                for (Map.Entry<HgRemoteRepository.Range, List<Nodeid>> e : between.entrySet()) {
                    DataEntry de = (DataEntry)rangeToEntry.get(e.getKey());
                    assert (de != null);
                    de.entries = e.getValue();
                    if (rootIndex == -1 && de.entries.size() == 1) {
                        int numberOfElementsExcludingRootAndHead = de.headIndex + 1;
                        rootIndex = numberOfElementsExcludingRootAndHead + 1;
                        if (this.debug) {
                            System.out.printf("On query %d found out exact number of missing elements: %d\n", totalQueries, numberOfElementsExcludingRootAndHead);
                        }
                    }
                    datas.add(de);
                }
                betweenBatch.clear();
                rangeToEntry.clear();
            }
            toQuery.clear();
        }
        if (rootIndex == -1) {
            throw new HgInvalidStateException("Shall not happen, provided between output is correct");
        }
        result[rootIndex] = branchRoot;
        boolean resultOk = true;
        LinkedList<Nodeid> fromRootToHead = new LinkedList<Nodeid>();
        IntVector missing = new IntVector();
        int i = 0;
        while (i <= rootIndex) {
            Nodeid n = result[i];
            if (n == null) {
                missing.add(i);
                resultOk = false;
            }
            fromRootToHead.addFirst(n);
            ++i;
        }
        if (this.debug) {
            System.out.println("Total queries:" + totalQueries);
        }
        if (!resultOk) {
            assert (missing.size() > 0);
            throw new HgInvalidStateException(String.format("Missing elements with indexes: %s", Arrays.toString(missing.toArray())));
        }
        return fromRootToHead;
    }

    public List<Nodeid> visitBranches(BranchChain bc) throws HgRemoteConnectionException {
        if (bc == null) {
            return Collections.emptyList();
        }
        List<Nodeid> mine = this.completeBranch(bc.branchRoot, bc.branchHead);
        if (bc.isTerminal() || bc.isRepoStart()) {
            return mine;
        }
        List<Nodeid> parentBranch1 = this.visitBranches(bc.p1);
        List<Nodeid> parentBranch2 = this.visitBranches(bc.p2);
        LinkedList<Nodeid> merged = new LinkedList<Nodeid>();
        ListIterator<Nodeid> i1 = parentBranch1.listIterator();
        ListIterator<Nodeid> i2 = parentBranch2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            Nodeid n2;
            Nodeid n1 = i1.next();
            if (n1.equals(n2 = i2.next())) {
                merged.addLast(n1);
                continue;
            }
            merged.add(n2);
            merged.add(n1);
            break;
        }
        while (i2.hasNext()) {
            merged.add(i2.next());
        }
        while (i1.hasNext()) {
            merged.add(i1.next());
        }
        ArrayList<Nodeid> rv = new ArrayList<Nodeid>(mine.size() + merged.size());
        rv.addAll(merged);
        rv.addAll(mine);
        return rv;
    }

    public void collectKnownRoots(BranchChain bc, Set<Nodeid> result) {
        if (bc == null) {
            return;
        }
        if (bc.isTerminal()) {
            result.add(bc.branchRoot);
            return;
        }
        if (bc.isRepoStart()) {
            return;
        }
        this.collectKnownRoots(bc.p1, result);
        this.collectKnownRoots(bc.p2, result);
    }

    public static final class BranchChain {
        public final Nodeid branchHead;
        public Nodeid branchRoot;
        public BranchChain p1;
        public BranchChain p2;

        public BranchChain(Nodeid head) {
            assert (head != null);
            this.branchHead = head;
        }

        public boolean isTerminal() {
            return this.p1 == null && this.p2 == null;
        }

        boolean isRepoStart() {
            return this.p1 == this.p2 && this.p1 != null && this.p1.branchHead == this.p1.branchRoot && this.p1.branchHead.isNull();
        }

        public String toString() {
            return String.format("BranchChain [root:%s, head:%s]", this.branchRoot, this.branchHead);
        }

        void dump() {
            System.out.println(this.toString());
            this.internalDump("  ");
        }

        private void internalDump(String prefix) {
            if (this.p1 != null) {
                System.out.println(String.valueOf(prefix) + this.p1.toString());
            } else if (this.p2 != null) {
                System.out.println(String.valueOf(prefix) + "NONE?!");
            }
            if (this.p2 != null) {
                System.out.println(String.valueOf(prefix) + this.p2.toString());
            } else if (this.p1 != null) {
                System.out.println(String.valueOf(prefix) + "NONE?!");
            }
            prefix = String.valueOf(prefix) + "  ";
            if (this.p1 != null) {
                this.p1.internalDump(prefix);
            }
            if (this.p2 != null) {
                this.p2.internalDump(prefix);
            }
        }
    }
}

