/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;
import org.tmatesoft.hg.core.HgAnnotateCommand;
import org.tmatesoft.hg.core.HgBlameInspector;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgIterateDirection;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.LineImpl;
import org.tmatesoft.hg.internal.RangePairSeq;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.ProgressSupport;

public class ReverseAnnotateInspector
implements HgBlameInspector,
HgBlameInspector.RevisionDescriptor.Recipient {
    private RangePairSeq activeEquals;
    private RangePairSeq intermediateEquals = new RangePairSeq();
    private boolean[] knownLines;
    private HgBlameInspector.RevisionDescriptor revisionDescriptor;
    private HgBlameInspector.BlockData lineContent;
    private IntMap<RangePairSeq> mergedRanges = new IntMap(10);
    private IntMap<RangePairSeq> equalRanges = new IntMap(10);
    private boolean activeEqualsComesFromMerge = false;
    private int[] lineRevisions;
    private int[] lineNumbers;

    public HgIterateDirection iterateDirection() {
        return HgIterateDirection.NewToOld;
    }

    public void report(int annotateRevIndex, HgAnnotateCommand.Inspector insp, ProgressSupport progress, CancelSupport cancel) throws HgCallbackTargetException, CancelledException {
        LineImpl li = new LineImpl();
        progress.start(this.lineRevisions.length);
        int i = 0;
        while (i < this.lineRevisions.length) {
            byte[] c = this.lineContent.elementAt(i).asArray();
            li.init(i + 1, this.lineNumbers[i] + 1, this.lineRevisions[i], c);
            insp.next(li);
            progress.worked(1);
            cancel.checkCancelled();
            ++i;
        }
        progress.done();
    }

    @Override
    public void start(HgBlameInspector.RevisionDescriptor rd) {
        this.revisionDescriptor = rd;
        if (this.knownLines == null) {
            this.lineContent = rd.target();
            this.knownLines = new boolean[this.lineContent.elementCount()];
            this.lineRevisions = new int[this.knownLines.length];
            Arrays.fill(this.lineRevisions, -1);
            this.lineNumbers = new int[this.knownLines.length];
            this.activeEquals = new RangePairSeq();
            this.activeEquals.add(0, 0, this.knownLines.length);
            this.equalRanges.put(rd.targetChangesetIndex(), this.activeEquals);
        } else {
            this.activeEquals = this.equalRanges.get(rd.targetChangesetIndex());
            if (this.activeEquals == null) {
                this.activeEquals = this.mergedRanges.get(rd.targetChangesetIndex());
                this.activeEqualsComesFromMerge = true;
                if (this.activeEquals == null) {
                    throw new HgInvalidStateException(String.format("Can't find previously visited revision %d (while in %d->%1$d diff)", rd.targetChangesetIndex(), rd.originChangesetIndex()));
                }
            }
        }
    }

    @Override
    public void done(HgBlameInspector.RevisionDescriptor rd) {
        RangePairSeq v = this.intermediateEquals.intersect(this.activeEquals);
        if (this.activeEqualsComesFromMerge) {
            this.mergedRanges.put(rd.originChangesetIndex(), v);
        } else {
            this.equalRanges.put(rd.originChangesetIndex(), v);
        }
        if (rd.isMerge() && !this.mergedRanges.containsKey(rd.mergeChangesetIndex())) {
            this.mergedRanges.put(rd.mergeChangesetIndex(), new RangePairSeq());
        }
        this.intermediateEquals.clear();
        this.activeEquals = null;
        this.activeEqualsComesFromMerge = false;
        this.revisionDescriptor = null;
    }

    @Override
    public void same(HgBlameInspector.EqualBlock block) {
        this.intermediateEquals.add(block.originStart(), block.targetStart(), block.length());
    }

    @Override
    public void added(HgBlameInspector.AddBlock block) {
        RangePairSeq rs = null;
        if (this.revisionDescriptor.isMerge() && block.originChangesetIndex() == this.revisionDescriptor.mergeChangesetIndex() && (rs = this.mergedRanges.get(this.revisionDescriptor.mergeChangesetIndex())) == null) {
            rs = new RangePairSeq();
            this.mergedRanges.put(this.revisionDescriptor.mergeChangesetIndex(), rs);
        }
        if (this.activeEquals.size() == 0) {
            return;
        }
        int i = 0;
        int ln = block.firstAddedLine();
        int x = block.totalAddedLines();
        while (i < x) {
            int lnInFinal = this.activeEquals.mapLineIndex(ln);
            if (lnInFinal != -1) {
                if (rs != null) {
                    rs.add(block.insertedAt() + i, lnInFinal, 1);
                } else {
                    this.line(lnInFinal, ln, block.targetChangesetIndex());
                }
                this.knownLines[lnInFinal] = true;
            }
            ++i;
            ++ln;
        }
    }

    @Override
    public void changed(HgBlameInspector.ChangeBlock block) {
        this.added(block);
    }

    @Override
    public void deleted(HgBlameInspector.DeleteBlock block) {
    }

    private void line(int lineNumber, int firstAppearance, int changesetRevIndex) {
        this.lineRevisions[lineNumber] = changesetRevIndex;
        this.lineNumbers[lineNumber] = firstAppearance;
    }
}

