/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.BitSet;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.RevisionSet;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;

public class RevisionDescendants {
    private final HgRepository repo;
    private final int rootRevIndex;
    private final int tipRevIndex;
    private final BitSet descendants;
    private RevisionSet revset;

    public RevisionDescendants(HgRepository hgRepo, int revisionIndex) throws HgRuntimeException {
        this.repo = hgRepo;
        this.rootRevIndex = revisionIndex;
        this.tipRevIndex = this.repo.getChangelog().getLastRevision();
        if (revisionIndex < 0 || revisionIndex > this.tipRevIndex) {
            String m = "Revision to build descendants for shall be in range [%d,%d], not %d";
            throw new IllegalArgumentException(String.format(m, 0, this.tipRevIndex, revisionIndex));
        }
        this.descendants = new BitSet(this.tipRevIndex - this.rootRevIndex + 1);
    }

    public void build() throws HgRuntimeException {
        final BitSet result = this.descendants;
        result.set(0);
        if (this.rootRevIndex == this.tipRevIndex) {
            return;
        }
        this.repo.getChangelog().indexWalk(this.rootRevIndex + 1, this.tipRevIndex, new Revlog.ParentInspector(){
            private int i = 1;

            @Override
            public void next(int revisionIndex, Nodeid revision, int parent1, int parent2, Nodeid nidParent1, Nodeid nidParent2) {
                int rx;
                int p1x = parent1 - RevisionDescendants.this.rootRevIndex;
                int p2x = parent2 - RevisionDescendants.this.rootRevIndex;
                boolean p1IsDescendant = false;
                boolean p2IsDescendant = false;
                if (p1x >= 0) {
                    if (!$assertionsDisabled && p1x >= result.size()) {
                        throw new AssertionError();
                    }
                    p1IsDescendant = result.get(p1x);
                }
                if (p2x >= 0) {
                    if (!$assertionsDisabled && p2x >= result.size()) {
                        throw new AssertionError();
                    }
                    p2IsDescendant = result.get(p2x);
                }
                if ((rx = revisionIndex - RevisionDescendants.this.rootRevIndex) != this.i) {
                    throw new HgInvalidStateException(String.format("Sanity check failed. Revision %d. Expected:%d, was:%d", revisionIndex, rx, this.i));
                }
                result.set(rx, p1IsDescendant || p2IsDescendant);
                ++this.i;
            }
        });
    }

    public boolean isCandidate(int revIndex) {
        return revIndex >= this.rootRevIndex && revIndex <= this.tipRevIndex;
    }

    public boolean hasDescendants() {
        return this.descendants.nextSetBit(this.rootRevIndex + 1) != -1;
    }

    public boolean isDescendant(int revisionIndex) {
        assert (this.isCandidate(revisionIndex));
        int ix = revisionIndex - this.rootRevIndex;
        assert (ix < this.descendants.size());
        return this.descendants.get(ix);
    }

    public RevisionSet asRevisionSet() {
        if (this.revset == null) {
            final ArrayList<Nodeid> revisions = new ArrayList<Nodeid>(this.descendants.cardinality());
            this.repo.getChangelog().indexWalk(this.rootRevIndex, this.tipRevIndex, new Revlog.RevisionInspector(){

                @Override
                public void next(int revisionIndex, Nodeid revision, int linkedRevisionIndex) throws HgRuntimeException {
                    if (RevisionDescendants.this.isDescendant(revisionIndex)) {
                        revisions.add(revision);
                    }
                }
            });
            assert (revisions.size() == this.descendants.cardinality());
            this.revset = new RevisionSet(revisions);
        }
        return this.revset;
    }
}

