/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.Arrays;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class RevisionLookup
implements RevlogStream.Inspector {
    private final RevlogStream content;
    private int[] nodeidHashes;

    public RevisionLookup(RevlogStream stream) {
        assert (stream != null);
        this.content = stream;
    }

    public static RevisionLookup createFor(RevlogStream stream) throws HgRuntimeException {
        RevisionLookup rv = new RevisionLookup(stream);
        int revCount = stream.revisionCount();
        rv.prepare(revCount);
        if (revCount > 0) {
            stream.iterate(0, revCount - 1, false, rv);
        }
        return rv;
    }

    public void prepare(int count) {
        this.nodeidHashes = new int[count];
        Arrays.fill(this.nodeidHashes, Integer.MIN_VALUE);
    }

    public void next(int index, byte[] nodeid) {
        this.nodeidHashes[index] = Nodeid.hashCode(nodeid);
    }

    public void next(int index, Nodeid nodeid) {
        this.nodeidHashes[index] = nodeid.hashCode();
    }

    public int findIndex(Nodeid nodeid) throws HgInvalidControlFileException, HgInvalidRevisionException {
        int hash = nodeid.hashCode();
        int i = 0;
        while (i < this.nodeidHashes.length) {
            byte[] nodeidAtI;
            if (this.nodeidHashes[i] == hash && nodeid.equalsTo(nodeidAtI = this.content.nodeid(i))) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) {
        this.next(revisionIndex, nodeid);
    }
}

