/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;

public final class RevisionSet
implements Iterable<Nodeid> {
    private final Set<Nodeid> elements;

    public RevisionSet(Nodeid ... revisions) {
        this(revisions == null ? null : Arrays.asList(revisions));
    }

    public RevisionSet(Collection<Nodeid> revisions) {
        this(revisions == null ? new HashSet<Nodeid>() : new HashSet<Nodeid>(revisions));
    }

    private RevisionSet(HashSet<Nodeid> revisions) {
        this.elements = revisions.isEmpty() ? Collections.emptySet() : revisions;
    }

    public RevisionSet roots(HgParentChildMap<HgChangelog> ph) {
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        for (Nodeid n : this.elements) {
            assert (ph.knownNode(n));
            Nodeid p1 = ph.firstParent(n);
            if (p1 != null && this.elements.contains(p1)) {
                copy.remove(n);
                continue;
            }
            Nodeid p2 = ph.secondParent(n);
            if (p2 == null || !this.elements.contains(p2)) continue;
            copy.remove(n);
        }
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet roots(HgRepository repo) {
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        HgChangelog clog = repo.getChangelog();
        byte[] parent1 = new byte[20];
        byte[] parent2 = new byte[20];
        int[] parentRevs = new int[2];
        for (Nodeid n : this.elements) {
            assert (clog.isKnown(n));
            clog.parents(clog.getRevisionIndex(n), parentRevs, parent1, parent2);
            if (parentRevs[0] != -1 && this.elements.contains(new Nodeid(parent1, false))) {
                copy.remove(n);
                continue;
            }
            if (parentRevs[1] == -1 || !this.elements.contains(new Nodeid(parent2, false))) continue;
            copy.remove(n);
        }
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet heads(HgParentChildMap<HgChangelog> ph) {
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        for (Nodeid n : this.elements) {
            assert (ph.knownNode(n));
            Nodeid p1 = ph.firstParent(n);
            Nodeid p2 = ph.secondParent(n);
            if (p1 != null && this.elements.contains(p1)) {
                copy.remove(p1);
            }
            if (p2 == null || !this.elements.contains(p2)) continue;
            copy.remove(p2);
        }
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet ancestors(RevisionSet children, HgParentChildMap<HgChangelog> parentHelper) {
        if (this.isEmpty()) {
            return this;
        }
        if (children.isEmpty()) {
            return children;
        }
        RevisionSet chRoots = children.roots(parentHelper);
        HashSet<Nodeid> ancestors = new HashSet<Nodeid>();
        Set<Nodeid> childrenToCheck = chRoots.elements;
        while (!childrenToCheck.isEmpty()) {
            HashSet<Nodeid> nextRound = new HashSet<Nodeid>();
            for (Nodeid n : childrenToCheck) {
                Nodeid p1 = parentHelper.firstParent(n);
                Nodeid p2 = parentHelper.secondParent(n);
                if (p1 != null && this.elements.contains(p1)) {
                    nextRound.add(p1);
                }
                if (p2 == null || !this.elements.contains(p2)) continue;
                nextRound.add(p2);
            }
            ancestors.addAll(nextRound);
            childrenToCheck = nextRound;
        }
        return new RevisionSet(ancestors);
    }

    public RevisionSet children(HgParentChildMap<HgChangelog> parentHelper) {
        if (this.isEmpty()) {
            return this;
        }
        List<Nodeid> children = parentHelper.childrenOf(this.elements);
        return new RevisionSet(new HashSet<Nodeid>(children));
    }

    public RevisionSet intersect(RevisionSet other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        copy.retainAll(other.elements);
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet subtract(RevisionSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            return this;
        }
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        copy.removeAll(other.elements);
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet union(RevisionSet other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        HashSet<Nodeid> copy = new HashSet<Nodeid>(this.elements);
        copy.addAll(other.elements);
        return copy.size() == this.elements.size() ? this : new RevisionSet(copy);
    }

    public RevisionSet symmetricDifference(RevisionSet other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        HashSet<Nodeid> copyA = new HashSet<Nodeid>(this.elements);
        HashSet<Nodeid> copyB = new HashSet<Nodeid>(other.elements);
        copyA.removeAll(other.elements);
        copyB.removeAll(this.elements);
        copyA.addAll(copyB);
        return new RevisionSet(copyA);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    public List<Nodeid> asList() {
        return new ArrayList<Nodeid>(this.elements);
    }

    @Override
    public Iterator<Nodeid> iterator() {
        return this.elements.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (!this.isEmpty()) {
            sb.append(this.elements.size());
            sb.append(':');
        }
        for (Nodeid n : this.elements) {
            sb.append(n.shortNotation());
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 1, '>');
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RevisionSet)) {
            return false;
        }
        return this.elements.equals(((RevisionSet)obj).elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

