/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.util.WeakHashMap;

public class RevlogChangeMonitor {
    private final WeakHashMap<File, Long> lastKnownSize;
    private final WeakHashMap<File, Long> lastKnownTime;
    private final File soleFile;
    private long soleFileSize = -1L;
    private long soleFileTime = -1L;

    public RevlogChangeMonitor() {
        this.lastKnownSize = new WeakHashMap();
        this.lastKnownTime = new WeakHashMap();
        this.soleFile = null;
    }

    public RevlogChangeMonitor(File f) {
        assert (f != null);
        this.lastKnownTime = null;
        this.lastKnownSize = null;
        this.soleFile = f;
    }

    public void touch(File f) {
        assert (f != null);
        if (this.lastKnownSize == null) {
            assert (f == this.soleFile);
            this.soleFileSize = f.length();
            this.soleFileTime = f.lastModified();
        } else {
            this.lastKnownSize.put(f, f.length());
            this.lastKnownTime.put(f, f.lastModified());
        }
    }

    public boolean hasChanged(File f) {
        assert (f != null);
        if (this.lastKnownSize == null) {
            assert (f == this.soleFile);
            return this.soleFileSize != f.length() || this.soleFileTime != f.lastModified();
        }
        Long lastSize = this.lastKnownSize.get(f);
        Long lastTime = this.lastKnownTime.get(f);
        if (lastSize == null || lastTime == null) {
            return true;
        }
        return f.length() != lastSize.longValue() || f.lastModified() != lastTime.longValue();
    }
}

