/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.util.zip.Deflater;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.DeflaterDataSerializer;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public class RevlogCompressor {
    private final SessionContext ctx;
    private final Deflater zip;
    private DataSerializer.DataSource sourceData;
    private int compressedLen;

    public RevlogCompressor(SessionContext sessionCtx) {
        this.ctx = sessionCtx;
        this.zip = new Deflater();
    }

    public void reset(DataSerializer.DataSource source) {
        this.sourceData = source;
        this.compressedLen = -1;
    }

    public int writeCompressedData(DataSerializer out) throws HgIOException, HgRuntimeException {
        this.zip.reset();
        DeflaterDataSerializer dds = new DeflaterDataSerializer(out, this.zip, this.sourceData.serializeLength());
        this.sourceData.serialize(dds);
        dds.finish();
        return this.zip.getTotalOut();
    }

    public int getCompressedLength() throws HgRuntimeException {
        if (this.compressedLen != -1) {
            return this.compressedLen;
        }
        Counter counter = new Counter();
        try {
            this.compressedLen = this.writeCompressedData(counter);
            assert (counter.totalWritten == this.compressedLen);
            return this.compressedLen;
        }
        catch (HgIOException ex) {
            this.ctx.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, "Failed estimating compressed length of revlog data");
            return counter.totalWritten;
        }
    }

    private static class Counter
    extends DataSerializer {
        public int totalWritten = 0;

        private Counter() {
        }

        @Override
        public void writeByte(byte ... values) throws HgIOException {
            this.totalWritten += values.length;
        }

        @Override
        public void writeInt(int ... values) throws HgIOException {
            this.totalWritten += 4 * values.length;
        }

        @Override
        public void write(byte[] data, int offset, int length) throws HgIOException {
            this.totalWritten += length;
        }
    }
}

