/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public abstract class RevlogDelegate
implements RevlogStream.Inspector {
    private final RevlogStream.Inspector next;
    private Nodeid nid;
    private final RevlogDelegate nextAsRD;

    protected RevlogDelegate(RevlogStream.Inspector nextInChain) {
        this.next = nextInChain;
        this.nextAsRD = nextInChain instanceof RevlogDelegate ? (RevlogDelegate)nextInChain : null;
    }

    public void walk(HgRepository hgRepo, RevlogStream stream, int from, int to) {
        stream.iterate(from, to, false, this);
        this.postWalk(hgRepo);
    }

    protected void postWalk(HgRepository hgRepo) {
        if (this.nextAsRD != null) {
            this.nextAsRD.postWalk(hgRepo);
        }
    }

    protected Nodeid getRevision(byte[] nodeid) {
        if (this.nid == null) {
            this.nid = Nodeid.fromBinary(nodeid, 0);
        }
        return this.nid;
    }

    protected void setRevision(Nodeid nodeid) {
        this.nid = nodeid;
    }

    @Override
    public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
        if (this.next != null) {
            if (this.nextAsRD != null) {
                this.nextAsRD.setRevision(this.nid);
            }
            this.next.next(revisionIndex, actualLen, baseRevision, linkRevision, parent1Revision, parent2Revision, nodeid, data);
        }
        this.nid = null;
    }
}

