/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class RevlogDump {
    private static Pattern controlCharPattern = Pattern.compile("\\p{Cntrl}");
    private static String[] replacements = new String[33];
    private static boolean leaveNewlineInData;

    static {
        int i = 0;
        while (i < 32) {
            RevlogDump.replacements[i] = String.format("\\\\%X", i);
            ++i;
        }
        RevlogDump.replacements[32] = String.format("\\\\%X", 127);
        leaveNewlineInData = true;
    }

    public static void main(String[] args) throws Exception {
        String repo = "/temp/hg/hello/.hg/";
        String filename = "store/00changelog.i";
        boolean dumpDataFull = true;
        boolean dumpDataStats = false;
        if (args.length > 1) {
            repo = args[0];
            filename = args[1];
            dumpDataFull = args.length > 2 ? "dumpData".equals(args[2]) : false;
            dumpDataStats = args.length > 2 ? "dumpDataStats".equals(args[2]) : false;
        }
        boolean needRevData = dumpDataFull || dumpDataStats;
        RevlogReader rr = new RevlogReader(new File(repo, filename)).needData(needRevData);
        rr.init(needRevData);
        System.out.printf("%#8x, inline: %b\n", rr.versionField, rr.inlineData);
        System.out.println("Index    Offset      Flags     Packed     Actual   Base Rev   Link Rev  Parent1  Parent2     nodeid");
        ByteBuffer data = null;
        while (rr.hasMore()) {
            String resultString;
            rr.readNext();
            System.out.printf("%4d:%14d %6X %10d %10d %10d %10d %8d %8d     %040x\n", rr.entryIndex, rr.offset, rr.flags, rr.compressedLen, rr.actualLen, rr.baseRevision, rr.linkRevision, rr.parent1Revision, rr.parent2Revision, new BigInteger(rr.nodeid));
            if (!needRevData) continue;
            if (rr.getDataLength() == 0) {
                resultString = "<NO DATA>";
            } else {
                data = RevlogDump.ensureCapacity(data, rr.getDataLength());
                rr.getData(data);
                data.flip();
                resultString = RevlogDump.buildString(data, rr.isPatch(), dumpDataFull);
            }
            if (resultString.endsWith("\n")) {
                System.out.print(resultString);
                continue;
            }
            System.out.println(resultString);
        }
        rr.done();
    }

    private static ByteBuffer ensureCapacity(ByteBuffer src, int requiredCap) {
        if (src == null || src.capacity() < requiredCap) {
            return ByteBuffer.allocate((1 + requiredCap) * 3 / 2);
        }
        src.clear();
        return src;
    }

    private static String buildString(ByteBuffer data, boolean isPatch, boolean completeDataDump) throws IOException, UnsupportedEncodingException {
        if (isPatch) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data.array(), data.arrayOffset(), data.remaining()));
            StringBuilder sb = new StringBuilder();
            sb.append("<PATCH>:\n");
            while (dis.available() > 0) {
                int s = dis.readInt();
                int e = dis.readInt();
                int l = dis.readInt();
                sb.append(String.format("%d..%d, %d", s, e, l));
                if (completeDataDump) {
                    byte[] src = new byte[l];
                    dis.read(src, 0, l);
                    sb.append(":");
                    sb.append(RevlogDump.escape(new String(src, 0, l, "UTF-8")));
                } else {
                    dis.skipBytes(l);
                }
                sb.append('\n');
            }
            return sb.toString();
        }
        if (completeDataDump) {
            return RevlogDump.escape(new String(data.array(), data.arrayOffset(), data.remaining(), "UTF-8"));
        }
        return String.format("<DATA>:%d bytes", data.remaining());
    }

    private static String escape(CharSequence possiblyWithBinary) {
        Matcher m = controlCharPattern.matcher(possiblyWithBinary);
        StringBuffer rv = new StringBuffer();
        while (m.find()) {
            char c = m.group().charAt(0);
            if (leaveNewlineInData && c == '\n') continue;
            char x = c;
            m.appendReplacement(rv, replacements[x == '\u007f' ? 32 : (int)x]);
        }
        m.appendTail(rv);
        return rv.toString();
    }

    public static class RevlogReader {
        private final File file;
        private boolean needRevData;
        private DataInputStream dis;
        private boolean inlineData;
        public int versionField;
        private FileChannel dataStream;
        public int entryIndex;
        private byte[] data;
        private int dataOffset;
        private int dataLen;
        public long offset;
        public int flags;
        public int baseRevision;
        public int linkRevision;
        public int parent1Revision;
        public int parent2Revision;
        public int compressedLen;
        public int actualLen;
        public byte[] nodeid = new byte[21];

        public RevlogReader(File f) {
            assert (f.getName().endsWith(".i"));
            this.file = f;
        }

        public RevlogReader needData(boolean needData) {
            this.needRevData = needData;
            return this;
        }

        public void init(boolean mayRequireData) throws IOException {
            DataInputStream di = this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            this.dis.mark(10);
            this.versionField = di.readInt();
            this.dis.reset();
            this.inlineData = (this.versionField & 0x10000) != 0;
            this.dataStream = null;
            if (!this.inlineData && mayRequireData) {
                String fname = this.file.getAbsolutePath();
                this.dataStream = new FileInputStream(new File(String.valueOf(fname.substring(0, fname.length() - 2)) + ".d")).getChannel();
            }
            this.entryIndex = -1;
        }

        public void startFrom(int startEntryIndex) throws IOException {
            long actualSkip;
            if (this.dis == null) {
                throw new IllegalStateException("Call #init() first");
            }
            if (this.entryIndex != -1 && startEntryIndex != 0) {
                throw new IllegalStateException("Can't seek once iteration has started");
            }
            if (this.dataStream == null) {
                throw new IllegalStateException("Sorry, initial seek is now supported for separate .i/.d only");
            }
            long newPos = startEntryIndex * 64;
            do {
                if ((actualSkip = this.dis.skip(newPos)) > 0L) continue;
                throw new IllegalStateException(String.valueOf(actualSkip));
            } while ((newPos -= actualSkip) > 0L);
            this.entryIndex = startEntryIndex - 1;
        }

        public boolean hasMore() throws IOException {
            return this.dis.available() > 0;
        }

        public void readNext() throws IOException, DataFormatException {
            ++this.entryIndex;
            DataInputStream di = this.dis;
            long l = di.readLong();
            this.offset = this.entryIndex == 0 ? 0L : l >>> 16;
            this.flags = (int)(l & 0xFFFFL);
            this.compressedLen = di.readInt();
            this.actualLen = di.readInt();
            this.baseRevision = di.readInt();
            this.linkRevision = di.readInt();
            this.parent1Revision = di.readInt();
            this.parent2Revision = di.readInt();
            di.readFully(this.nodeid, 1, 20);
            this.dis.skipBytes(12);
            this.data = new byte[this.compressedLen];
            if (this.inlineData) {
                di.readFully(this.data);
            } else if (this.needRevData) {
                this.dataStream.position(this.offset);
                this.dataStream.read(ByteBuffer.wrap(this.data));
            }
            if (this.needRevData) {
                if (this.compressedLen == 0) {
                    this.data = null;
                    this.dataLen = 0;
                    this.dataOffset = 0;
                } else if (this.data[0] == 120) {
                    Inflater zlib = new Inflater();
                    zlib.setInput(this.data, 0, this.compressedLen);
                    byte[] result = new byte[this.actualLen * 3];
                    int resultLen = zlib.inflate(result);
                    zlib.end();
                    this.data = result;
                    this.dataOffset = 0;
                    this.dataLen = resultLen;
                } else if (this.data[0] == 117) {
                    this.dataOffset = 1;
                    this.dataLen = this.data.length - 1;
                } else {
                    this.dataOffset = 0;
                    this.dataLen = this.data.length;
                }
            }
        }

        public int getDataLength() {
            return this.dataLen;
        }

        public void getData(ByteBuffer bb) {
            assert (bb.remaining() >= this.dataLen);
            bb.put(this.data, this.dataOffset, this.dataLen);
        }

        public boolean isPatch() {
            assert (this.entryIndex != -1);
            return this.baseRevision != this.entryIndex;
        }

        public boolean isInline() {
            assert (this.dis != null);
            return this.inlineData;
        }

        public void done() throws IOException {
            this.dis.close();
            this.dis = null;
            if (this.dataStream != null) {
                this.dataStream.close();
                this.dataStream = null;
            }
        }
    }
}

