/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Inflater;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ByteArrayDataAccess;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataAccessProvider;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.FilterDataAccess;
import org.tmatesoft.hg.internal.InflaterDataAccess;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.internal.RevlogChangeMonitor;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;

public class RevlogStream {
    static final int INLINEDATA = 65536;
    private int[] indexRecordOffset;
    private int[] baseRevisions;
    private boolean inline = false;
    private final File indexFile;
    private File dataFile;
    private final Internals repo;
    private SoftReference<CachedRevision> lastRevisionRead;
    private final ReferenceQueue<CachedRevision> lastRevisionQueue = new ReferenceQueue();
    private final RevlogChangeMonitor changeTracker;
    private List<Observer> observers;
    private boolean shallDropDerivedCaches = false;

    public RevlogStream(Internals hgRepo, File indexFile) {
        this.repo = hgRepo;
        this.indexFile = indexFile;
        this.changeTracker = this.repo.getRevlogTracker(indexFile);
    }

    public boolean exists() {
        return this.indexFile.exists();
    }

    DataAccess getIndexStream(boolean shortRead) {
        DataAccessProvider dataAccess = this.repo.getDataAccess();
        return dataAccess.createReader(this.indexFile, shortRead);
    }

    DataAccess getDataStream() {
        DataAccessProvider dataAccess = this.repo.getDataAccess();
        return dataAccess.createReader(this.getDataFile(), false);
    }

    DataSerializer getIndexStreamWriter(Transaction tr) throws HgIOException {
        DataAccessProvider dataAccess = this.repo.getDataAccess();
        return dataAccess.createWriter(tr, this.indexFile, true);
    }

    DataSerializer getDataStreamWriter(Transaction tr) throws HgIOException {
        DataAccessProvider dataAccess = this.repo.getDataAccess();
        return dataAccess.createWriter(tr, this.getDataFile(), true);
    }

    private File getDataFile() {
        if (this.dataFile == null) {
            String indexName = this.indexFile.getName();
            this.dataFile = new File(this.indexFile.getParentFile(), String.valueOf(indexName.substring(0, indexName.length() - 1)) + "d");
        }
        return this.dataFile;
    }

    public HgInvalidControlFileException initWithIndexFile(HgInvalidControlFileException ex) {
        return ex.setFile(this.indexFile);
    }

    public HgIOException initWithIndexFile(HgIOException ex) {
        return ex.setFile(this.indexFile);
    }

    public HgInvalidControlFileException initWithDataFile(HgInvalidControlFileException ex) {
        return ex.setFile(this.inline ? this.indexFile : this.getDataFile());
    }

    String getDataFileName() {
        return this.inline ? this.indexFile.getPath() : this.getDataFile().getPath();
    }

    public boolean isInlineData() throws HgInvalidControlFileException {
        this.initOutline();
        return this.inline;
    }

    public int revisionCount() throws HgInvalidControlFileException {
        this.initOutline();
        return this.baseRevisions.length;
    }

    public int dataLength(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        revisionIndex = this.checkRevisionIndex(revisionIndex);
        DataAccess daIndex = this.getIndexStream(true);
        try {
            int actualLen;
            int recordOffset = this.getIndexOffsetInt(revisionIndex);
            daIndex.seek(recordOffset + 12);
            int n = actualLen = daIndex.readInt();
            return n;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException(null, ex, this.indexFile).setRevisionIndex(revisionIndex);
        }
        finally {
            daIndex.done();
        }
    }

    public byte[] nodeid(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        revisionIndex = this.checkRevisionIndex(revisionIndex);
        DataAccess daIndex = this.getIndexStream(true);
        try {
            int recordOffset = this.getIndexOffsetInt(revisionIndex);
            daIndex.seek(recordOffset + 32);
            byte[] rv = new byte[20];
            daIndex.readBytes(rv, 0, 20);
            byte[] byArray = rv;
            return byArray;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Revision lookup failed", ex, this.indexFile).setRevisionIndex(revisionIndex);
        }
        finally {
            daIndex.done();
        }
    }

    public int linkRevision(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        revisionIndex = this.checkRevisionIndex(revisionIndex);
        DataAccess daIndex = this.getIndexStream(true);
        try {
            int linkRev;
            int recordOffset = this.getIndexOffsetInt(revisionIndex);
            daIndex.seek(recordOffset + 20);
            int n = linkRev = daIndex.readInt();
            return n;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Linked revision lookup failed", ex, this.indexFile).setRevisionIndex(revisionIndex);
        }
        finally {
            daIndex.done();
        }
    }

    public int baseRevision(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        revisionIndex = this.checkRevisionIndex(revisionIndex);
        return this.getBaseRevision(revisionIndex);
    }

    public int[] parents(int revisionIndex, int[] parents) throws HgInvalidControlFileException, HgInvalidRevisionException {
        assert (parents.length > 1);
        revisionIndex = this.checkRevisionIndex(revisionIndex);
        DataAccess daIndex = this.getIndexStream(true);
        try {
            int recordOffset = this.getIndexOffsetInt(revisionIndex);
            daIndex.seek(recordOffset + 24);
            int p1 = daIndex.readInt();
            int p2 = daIndex.readInt();
            parents[0] = p1 == -1 ? -1 : p1;
            parents[1] = p2 == -1 ? -1 : p2;
            int[] nArray = parents;
            return nArray;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Parents lookup failed", ex, this.indexFile).setRevisionIndex(revisionIndex);
        }
        finally {
            daIndex.done();
        }
    }

    public int findRevisionIndex(Nodeid nodeid) throws HgInvalidControlFileException {
        int indexSize = this.revisionCount();
        DataAccess daIndex = this.getIndexStream(false);
        try {
            byte[] nodeidBuf = new byte[20];
            int i = 0;
            while (i < indexSize) {
                daIndex.skip(8);
                int compressedLen = daIndex.readInt();
                daIndex.skip(20);
                daIndex.readBytes(nodeidBuf, 0, 20);
                if (nodeid.equalsTo(nodeidBuf)) {
                    int n = i;
                    return n;
                }
                try {
                    daIndex.skip(this.inline ? 12 + compressedLen : 12);
                    ++i;
                }
                catch (IOException ex) {
                    throw new HgInvalidControlFileException("Revision lookup failed", ex, this.indexFile).setRevision(nodeid);
                }
            }
        }
        finally {
            daIndex.done();
        }
        return Integer.MIN_VALUE;
    }

    public long newEntryOffset() throws HgInvalidControlFileException {
        if (this.revisionCount() == 0) {
            return 0L;
        }
        DataAccess daIndex = this.getIndexStream(true);
        int lastRev = this.revisionCount() - 1;
        try {
            int recordOffset = this.getIndexOffsetInt(lastRev);
            daIndex.seek(recordOffset);
            long value = daIndex.readLong();
            int compressedLen = daIndex.readInt();
            long l = lastRev == 0 ? (long)compressedLen : (value >>>= 16) + (long)compressedLen;
            return l;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Linked revision lookup failed", ex, this.indexFile).setRevisionIndex(lastRev);
        }
        finally {
            daIndex.done();
        }
    }

    public void iterate(int start, int end, boolean needData, Inspector inspector) throws HgRuntimeException {
        this.initOutline();
        int indexSize = this.revisionCount();
        if (indexSize == 0) {
            return;
        }
        if (end == -3) {
            end = indexSize - 1;
        }
        if (start == -3) {
            start = indexSize - 1;
        }
        HgInternals.checkRevlogRange(start, end, indexSize - 1);
        ReaderN1 r = new ReaderN1(needData, inspector, this.repo.shallMergePatches());
        try {
            try {
                r.start(end - start + 1, this.getLastRevisionRead());
                r.range(start, end);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException(String.format("Failed reading [%d..%d]", start, end), ex, this.indexFile);
            }
        }
        finally {
            CachedRevision cr = r.finish();
            this.setLastRevisionRead(cr);
        }
    }

    /*
     * Exception decompiling
     */
    public void iterate(int[] sortedRevisions, boolean needData, Inspector inspector) throws HgRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void attach(Observer listener) {
        assert (listener != null);
        if (this.observers == null) {
            this.observers = new ArrayList<Observer>(3);
        }
        this.observers.add(listener);
    }

    public void detach(Observer listener) {
        assert (listener != null);
        if (this.observers != null) {
            this.observers.remove(listener);
        }
    }

    public boolean shallDropDerivedCaches() {
        if (this.shallDropDerivedCaches) {
            return this.shallDropDerivedCaches;
        }
        this.shallDropDerivedCaches = this.changeTracker.hasChanged(this.indexFile);
        return this.shallDropDerivedCaches;
    }

    void revisionAdded(int revisionIndex, Nodeid revision, int baseRevisionIndex, long revisionOffset) throws HgInvalidControlFileException {
        this.shallDropDerivedCaches = true;
        if (!this.outlineCached()) {
            return;
        }
        if (this.baseRevisions.length != revisionIndex) {
            throw new HgInvalidControlFileException(String.format("New entry's index shall be %d, not %d", this.baseRevisions.length, revisionIndex), null, this.indexFile);
        }
        if (baseRevisionIndex < 0 || baseRevisionIndex > this.baseRevisions.length) {
            throw new HgInvalidControlFileException(String.format("Base revision index %d doesn't fit [0..%d] range", baseRevisionIndex, this.baseRevisions.length), null, this.indexFile);
        }
        assert (revision != null);
        assert (!revision.isNull());
        int[] baseRevisionsCopy = new int[this.baseRevisions.length + 1];
        System.arraycopy(this.baseRevisions, 0, baseRevisionsCopy, 0, this.baseRevisions.length);
        baseRevisionsCopy[this.baseRevisions.length] = baseRevisionIndex;
        this.baseRevisions = baseRevisionsCopy;
        if (this.inline && this.indexRecordOffset != null) {
            assert (this.indexRecordOffset.length == revisionIndex);
            int[] indexRecordOffsetCopy = new int[this.indexRecordOffset.length + 1];
            System.arraycopy(this.indexRecordOffset, 0, indexRecordOffsetCopy, 0, this.indexRecordOffset.length);
            indexRecordOffsetCopy[this.indexRecordOffset.length] = RevlogStream.offsetFieldToInlineFileOffset(revisionOffset, revisionIndex);
            this.indexRecordOffset = indexRecordOffsetCopy;
        }
    }

    private int getBaseRevision(int revision) {
        return this.baseRevisions[revision];
    }

    private int getIndexOffsetInt(int revisionIndex) {
        return this.inline ? this.indexRecordOffset[revisionIndex] : revisionIndex * 64;
    }

    private int checkRevisionIndex(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        int last = this.revisionCount() - 1;
        if (revisionIndex == -3) {
            revisionIndex = last;
        }
        if (revisionIndex < 0 || revisionIndex > last) {
            throw new HgInvalidRevisionException(revisionIndex).setRevisionIndex(revisionIndex, 0, last);
        }
        return revisionIndex;
    }

    private boolean outlineCached() {
        return this.baseRevisions != null && this.baseRevisions.length > 0;
    }

    private static int offsetFieldToInlineFileOffset(long offset, int recordIndex) throws HgInvalidStateException {
        int o = Internals.ltoi(offset);
        if ((long)o != offset) {
            throw new HgInvalidStateException("Data too big, offset didn't fit to sizeof(int)");
        }
        return o + 64 * recordIndex;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initOutline() throws HgInvalidControlFileException {
        block18: {
            if (this.outlineCached()) {
                if (!this.changeTracker.hasChanged(this.indexFile)) {
                    return;
                }
                notifyReload = true;
            } else {
                notifyReload = false;
            }
            this.changeTracker.touch(this.indexFile);
            da = this.getIndexStream(false);
            try {
                if (da.isEmpty()) {
                    this.baseRevisions = new int[0];
                    this.inline = true;
                }
                versionField = da.readInt();
                da.readInt();
                this.inline = (versionField & 65536) != 0;
                resOffsets = null;
                entryCountGuess = Internals.ltoi(da.longLength() / 64L);
                if (this.inline) {
                    resOffsets = new IntVector(entryCountGuess >>>= 2, 5000);
                }
                resBases = new IntVector(entryCountGuess, 5000);
                offset = 0L;
                while (true) {
                    compressedLen = da.readInt();
                    da.readInt();
                    baseRevision = da.readInt();
                    resBases.add(baseRevision);
                    if (this.inline) {
                        o = RevlogStream.offsetFieldToInlineFileOffset(offset, resOffsets.size());
                        resOffsets.add(o);
                        da.skip(44 + compressedLen);
                    } else {
                        da.skip(44);
                    }
                    if (da.isEmpty()) {
                        this.baseRevisions = resBases.toArray(true);
                        if (this.inline) {
                            this.indexRecordOffset = resOffsets.toArray(true);
                        }
                        break;
                    }
                    l = da.readLong();
                    offset = l >>> 16;
                }
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed to analyze revlog index", ex, this.indexFile);
            }
            finally {
                da.done();
                if (!notifyReload || this.observers == null) break block18;
                ** for (l : this.observers)
            }
lbl-1000:
            // 1 sources

            {
                l.reloaded(this);
                continue;
            }
lbl55:
            // 1 sources

            this.shallDropDerivedCaches = false;
        }
    }

    private CachedRevision getLastRevisionRead() {
        return this.lastRevisionRead == null ? null : this.lastRevisionRead.get();
    }

    private void setLastRevisionRead(CachedRevision cr) {
        Reference<CachedRevision> r;
        while ((r = this.lastRevisionQueue.poll()) != null) {
            CachedRevision toClean = r.get();
            if (toClean == null || toClean.userData == null) continue;
            toClean.userData.done();
        }
        this.lastRevisionRead = cr != null ? new SoftReference<CachedRevision>(cr, this.lastRevisionQueue) : null;
    }

    static final class CachedRevision {
        final int revision;
        final DataAccess userData;

        public CachedRevision(int lastRevisionRead, DataAccess lastUserData) {
            this.revision = lastRevisionRead;
            this.userData = lastUserData;
        }
    }

    public static interface Inspector {
        public void next(int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, DataAccess var8) throws HgRuntimeException;
    }

    public static interface Observer {
        public void reloaded(RevlogStream var1);
    }

    final class ReaderN1 {
        private final Inspector inspector;
        private final boolean needData;
        private final boolean mergePatches;
        private DataAccess daIndex = null;
        private DataAccess daData = null;
        private Lifecycle.BasicCallback cb = null;
        private Lifecycle lifecycleListener = null;
        private int lastRevisionRead = Integer.MIN_VALUE;
        private DataAccess lastUserData;
        private final Inflater inflater = new Inflater();
        private final byte[] inflaterBuffer = new byte[10240];
        private final ByteBuffer inflaterOutBuffer = ByteBuffer.allocate(this.inflaterBuffer.length * 2);
        private final byte[] nodeidBuf = new byte[20];
        private long offset;
        private int flags;
        private int compressedLen;
        private int actualLen;
        private int baseRevision;
        private int linkRevision;
        private int parent1Revision;
        private int parent2Revision;

        public ReaderN1(boolean dataRequested, Inspector insp, boolean usePatchMerge) {
            assert (insp != null);
            this.needData = dataRequested;
            this.inspector = insp;
            this.mergePatches = usePatchMerge;
        }

        public void start(int totalWork, CachedRevision cachedRevision) {
            this.daIndex = RevlogStream.this.getIndexStream(totalWork <= 10);
            if (this.needData && !RevlogStream.this.inline) {
                this.daData = RevlogStream.this.getDataStream();
            }
            this.lifecycleListener = Adaptable.Factory.getAdapter(this.inspector, Lifecycle.class, null);
            if (this.lifecycleListener != null) {
                this.cb = new Lifecycle.BasicCallback();
                this.lifecycleListener.start(totalWork, this.cb, this.cb);
            }
            if (this.needData && cachedRevision != null) {
                this.lastUserData = cachedRevision.userData;
                this.lastRevisionRead = cachedRevision.revision;
                assert (this.lastUserData != null);
            }
        }

        public CachedRevision finish() {
            CachedRevision rv = null;
            if (this.lastUserData != null) {
                if (this.lastUserData instanceof ByteArrayDataAccess) {
                    rv = new CachedRevision(this.lastRevisionRead, this.lastUserData);
                } else {
                    this.lastUserData.done();
                }
                this.lastUserData = null;
            }
            if (this.lifecycleListener != null) {
                this.lifecycleListener.finish(this.cb);
                this.lifecycleListener = null;
                this.cb = null;
            }
            this.daIndex.done();
            if (this.daData != null) {
                this.daData.done();
                this.daData = null;
            }
            return rv;
        }

        private void readHeaderRecord(int i) throws IOException {
            if (RevlogStream.this.inline && this.needData) {
                this.daIndex.seek(RevlogStream.this.getIndexOffsetInt(i));
            }
            long l = this.daIndex.readLong();
            this.offset = i == 0 ? 0L : l >>> 16;
            this.flags = (int)(l & 0xFFFFL);
            this.compressedLen = this.daIndex.readInt();
            this.actualLen = this.daIndex.readInt();
            this.baseRevision = this.daIndex.readInt();
            this.linkRevision = this.daIndex.readInt();
            this.parent1Revision = this.daIndex.readInt();
            this.parent2Revision = this.daIndex.readInt();
            this.daIndex.readBytes(this.nodeidBuf, 0, 20);
            this.daIndex.skip(12);
        }

        private boolean isPatch(int i) {
            return this.baseRevision != i;
        }

        private DataAccess getStoredData(int i) throws IOException {
            DataAccess streamDataAccess;
            long streamOffset;
            DataAccess userDataAccess = null;
            if (RevlogStream.this.inline) {
                streamOffset = RevlogStream.this.getIndexOffsetInt(i) + 64;
                streamDataAccess = this.daIndex;
                this.daIndex.longSeek(streamOffset);
            } else {
                streamOffset = this.offset;
                streamDataAccess = this.daData;
                this.daData.longSeek(streamOffset);
            }
            if (streamDataAccess.isEmpty() || this.compressedLen == 0) {
                userDataAccess = new DataAccess();
            } else {
                byte firstByte = streamDataAccess.readByte();
                if (firstByte == 120) {
                    this.inflater.reset();
                    userDataAccess = new InflaterDataAccess(streamDataAccess, streamOffset, this.compressedLen, this.isPatch(i) ? -1 : this.actualLen, this.inflater, this.inflaterBuffer, this.inflaterOutBuffer);
                } else {
                    userDataAccess = firstByte == 117 ? new FilterDataAccess(streamDataAccess, streamOffset + 1L, this.compressedLen - 1) : new FilterDataAccess(streamDataAccess, streamOffset, this.compressedLen);
                }
            }
            return userDataAccess;
        }

        public boolean range(int start, int end) throws IOException, HgRuntimeException {
            byte[] userData;
            int i;
            if (this.needData && (i = RevlogStream.this.getBaseRevision(start)) < start) {
                if (this.lastRevisionRead != Integer.MIN_VALUE && i <= this.lastRevisionRead && this.lastRevisionRead < start) {
                    i = this.lastRevisionRead + 1;
                } else if (this.lastUserData != null) {
                    this.lastUserData.done();
                    this.lastUserData = null;
                }
            } else {
                i = start;
            }
            this.daIndex.seek(RevlogStream.this.getIndexOffsetInt(i));
            Patch patch = new Patch(false);
            if (this.needData && this.mergePatches && start - i > 2) {
                Patch ultimatePatch = new Patch(true);
                while (i < start) {
                    this.readHeaderRecord(i);
                    DataAccess userDataAccess = this.getStoredData(i);
                    if (this.lastUserData == null) {
                        assert (!this.isPatch(i));
                        this.lastUserData = userDataAccess;
                    } else {
                        assert (this.isPatch(i));
                        patch.read(userDataAccess);
                        userDataAccess.done();
                        ultimatePatch = ultimatePatch.apply(patch);
                        patch.clear();
                    }
                    ++i;
                }
                this.lastUserData.reset();
                userData = ultimatePatch.apply(this.lastUserData, this.actualLen);
                ultimatePatch.clear();
                this.lastUserData.done();
                this.lastUserData = new ByteArrayDataAccess(userData);
            }
            while (i <= end) {
                this.readHeaderRecord(i);
                DataAccess userDataAccess = null;
                if (this.needData) {
                    userDataAccess = this.getStoredData(i);
                    if (this.isPatch(i)) {
                        if (userDataAccess.isEmpty()) {
                            assert (this.lastUserData.length() == this.actualLen);
                            userDataAccess = this.lastUserData;
                        } else {
                            patch.read(userDataAccess);
                            userDataAccess.done();
                            this.lastUserData.reset();
                            userData = patch.apply(this.lastUserData, this.actualLen);
                            patch.clear();
                            userDataAccess = new ByteArrayDataAccess(userData);
                        }
                    }
                } else if (RevlogStream.this.inline) {
                    this.daIndex.skip(this.compressedLen);
                }
                if (i >= start) {
                    this.inspector.next(i, this.actualLen, this.baseRevision, this.linkRevision, this.parent1Revision, this.parent2Revision, this.nodeidBuf, userDataAccess);
                }
                if (this.cb != null && this.cb.isStopped()) {
                    return false;
                }
                if (userDataAccess != null) {
                    userDataAccess.reset();
                }
                if (this.lastUserData != null && this.lastUserData != userDataAccess) {
                    this.lastUserData.done();
                }
                this.lastUserData = userDataAccess;
                ++i;
            }
            this.lastRevisionRead = end;
            return true;
        }
    }
}

