/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.util.Path;

public final class RevlogStreamFactory {
    private final Internals repo;
    private final HashMap<Path, SoftReference<RevlogStream>> streamsCache;

    public RevlogStreamFactory(Internals hgRepo, boolean shallCacheRevlogs) {
        this.repo = hgRepo;
        this.streamsCache = shallCacheRevlogs ? new HashMap() : null;
    }

    RevlogStream create(File f) {
        return new RevlogStream(this.repo, f);
    }

    RevlogStream getStoreFile(Path path, boolean onlyIfExists) {
        RevlogStream cached;
        SoftReference<RevlogStream> ref = this.shallCacheRevlogs() ? this.streamsCache.get(path) : null;
        RevlogStream revlogStream = cached = ref == null ? null : ref.get();
        if (cached != null) {
            return cached;
        }
        File f = this.repo.getFileFromDataDir(path);
        if (!onlyIfExists || f.exists()) {
            RevlogStream s = this.create(f);
            if (this.shallCacheRevlogs()) {
                this.streamsCache.put(path, new SoftReference<RevlogStream>(s));
            }
            return s;
        }
        return null;
    }

    private boolean shallCacheRevlogs() {
        return this.streamsCache != null;
    }
}

