/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ByteArrayDataAccess;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.GeneratePatchInspector;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.internal.RevlogCompressor;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.Transaction;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidDataFormatException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Pair;

public class RevlogStreamWriter {
    private final DigestHelper dh = new DigestHelper();
    private final RevlogCompressor revlogDataZip;
    private final Transaction transaction;
    private int lastEntryBase = Integer.MIN_VALUE;
    private int lastEntryIndex = Integer.MIN_VALUE;
    private int lastEntryActualLen = -1;
    private Pair<Integer, byte[]> lastFullContent;
    private Nodeid lastEntryRevision;
    private IntMap<Nodeid> revisionCache = new IntMap(32);
    private RevlogStream revlogStream;

    public RevlogStreamWriter(SessionContext.Source ctxSource, RevlogStream stream, Transaction tr) {
        assert (ctxSource != null);
        assert (stream != null);
        assert (tr != null);
        this.revlogDataZip = new RevlogCompressor(ctxSource.getSessionContext());
        this.revlogStream = stream;
        this.transaction = tr;
    }

    public RevlogStream getRevlogStream() {
        return this.revlogStream;
    }

    public Pair<Integer, Nodeid> addPatchRevision(HgBundle.GroupElement ge, RevisionToIndexMap clogRevs, RevisionToIndexMap revlogRevs) throws HgIOException, HgRuntimeException {
        DataSerializer.DataSource ds;
        int revLen;
        this.populateLastEntryIndex();
        Nodeid nodeRev = ge.node();
        Nodeid csetRev = ge.cset();
        int linkRev = nodeRev.equals(csetRev) ? this.lastEntryIndex + 1 : clogRevs.revisionIndex(csetRev);
        assert (linkRev >= 0);
        Nodeid p1Rev = ge.firstParent();
        int p1 = p1Rev.isNull() ? -1 : revlogRevs.revisionIndex(p1Rev);
        Nodeid p2Rev = ge.secondParent();
        int p2 = p2Rev.isNull() ? -1 : revlogRevs.revisionIndex(p2Rev);
        Patch p = null;
        try {
            p = HgInternals.patchFromData(ge);
        }
        catch (IOException ex) {
            throw new HgIOException("Failed to read patch information", ex, null);
        }
        Nodeid patchBase = ge.patchBase();
        int patchBaseRev = patchBase.isNull() ? -1 : revlogRevs.revisionIndex(patchBase);
        int baseRev = this.lastEntryIndex == -1 ? 0 : this.revlogStream.baseRevision(patchBaseRev);
        byte[] complete = null;
        if (patchBaseRev == this.lastEntryIndex && this.lastEntryIndex != -1) {
            int patchBaseLen = this.dataLength(patchBaseRev);
            revLen = patchBaseLen + p.patchSizeDelta();
            ds = p.new Patch.PatchDataSource();
        } else {
            try {
                if (this.lastEntryIndex == -1) {
                    complete = p.apply(new ByteArrayDataAccess(new byte[0]), -1);
                    baseRev = 0;
                } else {
                    assert (patchBaseRev != -1);
                    ReadContentInspector insp = new ReadContentInspector().read(this.revlogStream, patchBaseRev);
                    complete = p.apply(new ByteArrayDataAccess(insp.content), -1);
                    baseRev = this.lastEntryIndex + 1;
                }
                ds = new DataSerializer.ByteArrayDataSource(complete);
                revLen = complete.length;
            }
            catch (IOException ex) {
                throw new HgInvalidDataFormatException("Failed to reconstruct revision", ex);
            }
        }
        this.doAdd(nodeRev, p1, p2, linkRev, baseRev, revLen, ds);
        if (complete != null) {
            this.lastFullContent = new Pair<Integer, byte[]>(this.lastEntryIndex, complete);
        }
        return new Pair<Integer, Nodeid>(this.lastEntryIndex, this.lastEntryRevision);
    }

    public Pair<Integer, Nodeid> addRevision(DataSerializer.DataSource content, int linkRevision, int p1, int p2) throws HgIOException, HgRuntimeException {
        this.populateLastEntryIndex();
        this.populateLastEntryContent();
        byte[] contentByteArray = this.toByteArray(content);
        Patch patch = GeneratePatchInspector.delta(this.lastFullContent.second(), contentByteArray);
        int patchSerializedLength = patch.serializedLength();
        boolean writeComplete = RevlogStreamWriter.preferCompleteOverPatch(patchSerializedLength, contentByteArray.length);
        DataSerializer.DataSource dataSource = writeComplete ? new DataSerializer.ByteArrayDataSource(contentByteArray) : patch.new Patch.PatchDataSource();
        Nodeid p1Rev = this.revision(p1);
        Nodeid p2Rev = this.revision(p2);
        Nodeid newRev = Nodeid.fromBinary(this.dh.sha1(p1Rev, p2Rev, contentByteArray).asBinary(), 0);
        this.doAdd(newRev, p1, p2, linkRevision, writeComplete ? this.lastEntryIndex + 1 : this.lastEntryBase, contentByteArray.length, dataSource);
        this.lastFullContent = new Pair<Integer, byte[]>(this.lastEntryIndex, contentByteArray);
        return new Pair<Integer, Nodeid>(this.lastEntryIndex, this.lastEntryRevision);
    }

    private Nodeid doAdd(Nodeid rev, int p1, int p2, int linkRevision, int baseRevision, int revLen, DataSerializer.DataSource dataSource) throws HgIOException, HgRuntimeException {
        assert (linkRevision >= 0);
        assert (baseRevision >= 0);
        assert (p1 == -1 || p1 >= 0);
        assert (p2 == -1 || p2 >= 0);
        assert (!rev.isNull());
        assert (revLen >= 0);
        this.revlogDataZip.reset(dataSource);
        boolean useCompressedData = RevlogStreamWriter.preferCompressedOverComplete(this.revlogDataZip.getCompressedLength(), dataSource.serializeLength());
        int compressedLen = useCompressedData ? this.revlogDataZip.getCompressedLength() : dataSource.serializeLength() + 1;
        DataSerializer dataFile = null;
        DataSerializer indexFile = null;
        try {
            indexFile = this.revlogStream.getIndexStreamWriter(this.transaction);
            boolean isInlineData = this.revlogStream.isInlineData();
            HeaderWriter revlogHeader = new HeaderWriter(isInlineData);
            revlogHeader.length(revLen, compressedLen);
            revlogHeader.nodeid(rev.toByteArray());
            revlogHeader.linkRevision(linkRevision);
            revlogHeader.parents(p1, p2);
            revlogHeader.baseRevision(baseRevision);
            long lastEntryOffset = this.revlogStream.newEntryOffset();
            revlogHeader.offset(lastEntryOffset);
            revlogHeader.serialize(indexFile);
            dataFile = isInlineData ? indexFile : this.revlogStream.getDataStreamWriter(this.transaction);
            if (useCompressedData) {
                int actualCompressedLenWritten = this.revlogDataZip.writeCompressedData(dataFile);
                if (actualCompressedLenWritten != compressedLen) {
                    throw new HgInvalidStateException(String.format("Expected %d bytes of compressed data, but actually wrote %d in %s", compressedLen, actualCompressedLenWritten, this.revlogStream.getDataFileName()));
                }
            } else {
                dataFile.writeByte(117);
                dataSource.serialize(dataFile);
            }
            this.lastEntryBase = revlogHeader.baseRevision();
            ++this.lastEntryIndex;
            this.lastEntryActualLen = revLen;
            this.lastEntryRevision = rev;
            this.revisionCache.put(this.lastEntryIndex, this.lastEntryRevision);
            this.revlogStream.revisionAdded(this.lastEntryIndex, this.lastEntryRevision, this.lastEntryBase, lastEntryOffset);
        }
        finally {
            indexFile.done();
            if (dataFile != null && dataFile != indexFile) {
                dataFile.done();
            }
        }
        return this.lastEntryRevision;
    }

    private byte[] toByteArray(DataSerializer.DataSource content) throws HgIOException, HgRuntimeException {
        DataSerializer.ByteArraySerializer ba = new DataSerializer.ByteArraySerializer();
        content.serialize(ba);
        return ba.toByteArray();
    }

    private Nodeid revision(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        if (revisionIndex == -1) {
            return Nodeid.NULL;
        }
        Nodeid n = this.revisionCache.get(revisionIndex);
        if (n == null) {
            n = Nodeid.fromBinary(this.revlogStream.nodeid(revisionIndex), 0);
            this.revisionCache.put(revisionIndex, n);
        }
        return n;
    }

    private int dataLength(int revisionIndex) throws HgInvalidControlFileException, HgInvalidRevisionException {
        assert (revisionIndex >= 0);
        if (revisionIndex == this.lastEntryIndex && this.lastEntryActualLen >= 0) {
            return this.lastEntryActualLen;
        }
        if (this.lastFullContent != null && this.lastFullContent.first() == revisionIndex) {
            return this.lastFullContent.second().length;
        }
        return this.revlogStream.dataLength(revisionIndex);
    }

    private void populateLastEntryIndex() throws HgRuntimeException {
        int revCount = this.revlogStream.revisionCount();
        this.lastEntryIndex = revCount == 0 ? -1 : revCount - 1;
    }

    private void populateLastEntryContent() throws HgIOException, HgRuntimeException {
        if (this.lastFullContent != null && this.lastFullContent.first() == this.lastEntryIndex) {
            return;
        }
        this.lastEntryRevision = Nodeid.NULL;
        if (this.lastEntryIndex != -1) {
            ReadContentInspector insp = new ReadContentInspector().read(this.revlogStream, this.lastEntryIndex);
            this.lastEntryBase = insp.baseRev;
            this.lastEntryRevision = insp.rev;
            this.lastFullContent = new Pair<Integer, byte[]>(this.lastEntryIndex, insp.content);
        } else {
            this.lastFullContent = new Pair<Integer, byte[]>(this.lastEntryIndex, new byte[0]);
        }
        assert (this.lastFullContent.first() == this.lastEntryIndex);
        assert (this.lastFullContent.second() != null);
    }

    public static boolean preferCompleteOverPatch(int patchLength, int fullContentLength) {
        return !RevlogStreamWriter.decideWorthEffort(patchLength, fullContentLength);
    }

    public static boolean preferCompressedOverComplete(int compressedLen, int fullContentLength) {
        if (compressedLen <= 0) {
            return false;
        }
        return RevlogStreamWriter.decideWorthEffort(compressedLen, fullContentLength);
    }

    private static boolean decideWorthEffort(int lengthWithExtraEffort, int lengthWithoutEffort) {
        return lengthWithExtraEffort < lengthWithoutEffort - (lengthWithoutEffort >>> 2);
    }

    public static class HeaderWriter
    implements DataSerializer.DataSource {
        private final ByteBuffer header;
        private final boolean isInline;
        private long offset;
        private int length;
        private int compressedLength;
        private int baseRev;
        private int linkRev;
        private int p1;
        private int p2;
        private byte[] nodeid;

        public HeaderWriter(boolean inline) {
            this.isInline = inline;
            this.header = ByteBuffer.allocate(64);
        }

        public HeaderWriter offset(long offset) {
            this.offset = offset;
            return this;
        }

        public int baseRevision() {
            return this.baseRev;
        }

        public HeaderWriter baseRevision(int baseRevision) {
            this.baseRev = baseRevision;
            return this;
        }

        public HeaderWriter length(int len, int compressedLen) {
            this.length = len;
            this.compressedLength = compressedLen;
            return this;
        }

        public HeaderWriter parents(int parent1, int parent2) {
            this.p1 = parent1;
            this.p2 = parent2;
            return this;
        }

        public HeaderWriter linkRevision(int linkRevision) {
            this.linkRev = linkRevision;
            return this;
        }

        public HeaderWriter nodeid(Nodeid n) {
            this.nodeid = n.toByteArray();
            return this;
        }

        public HeaderWriter nodeid(byte[] nodeidBytes) {
            this.nodeid = nodeidBytes;
            return this;
        }

        @Override
        public void serialize(DataSerializer out) throws HgIOException {
            this.header.clear();
            if (this.offset == 0L) {
                int version = 1;
                if (this.isInline) {
                    version |= 0x10000;
                }
                this.header.putInt(version);
                this.header.putInt(0);
            } else {
                this.header.putLong(this.offset << 16);
            }
            this.header.putInt(this.compressedLength);
            this.header.putInt(this.length);
            this.header.putInt(this.baseRev);
            this.header.putInt(this.linkRev);
            this.header.putInt(this.p1);
            this.header.putInt(this.p2);
            this.header.put(this.nodeid);
            out.write(this.header.array(), 0, this.header.capacity());
            this.offset += (long)this.compressedLength;
        }

        @Override
        public int serializeLength() {
            return this.header.capacity();
        }
    }

    private static class ReadContentInspector
    implements RevlogStream.Inspector {
        public int baseRev;
        public Nodeid rev;
        public byte[] content;
        private IOException failure;

        private ReadContentInspector() {
        }

        public ReadContentInspector read(RevlogStream rs, int revIndex) throws HgIOException, HgRuntimeException {
            assert (revIndex >= 0);
            rs.iterate(revIndex, revIndex, true, this);
            if (this.failure != null) {
                String m = String.format("Failed to get content of revision %d", revIndex);
                throw rs.initWithIndexFile(new HgIOException(m, this.failure, null));
            }
            return this;
        }

        @Override
        public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) {
            try {
                this.baseRev = baseRevision;
                this.rev = Nodeid.fromBinary(nodeid, 0);
                this.content = data.byteArray();
            }
            catch (IOException ex) {
                this.failure = ex;
            }
        }
    }

    public static interface RevisionToIndexMap {
        public int revisionIndex(Nodeid var1);
    }
}

