/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.TreeSet;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.EncodeDirPathHelper;
import org.tmatesoft.hg.util.PathRewrite;

class StoragePathHelper
implements PathRewrite {
    static final String STR_STORE = "store/";
    static final String STR_DATA = "data/";
    static final String STR_DH = "dh/";
    private final boolean store;
    private final boolean fncache;
    private final boolean dotencode;
    private final EncodeDirPathHelper dirPathRewrite;
    private final CharsetEncoder csEncoder;
    private final char[] hexEncodedByte = new char[]{'~', '0', '0'};
    private final ByteBuffer byteEncodingBuf;
    private final CharBuffer charEncodingBuf;

    public StoragePathHelper(boolean isStore, boolean isFncache, boolean isDotencode) {
        this(isStore, isFncache, isDotencode, Charset.defaultCharset());
    }

    public StoragePathHelper(boolean isStore, boolean isFncache, boolean isDotencode, Charset fsEncoding) {
        assert (fsEncoding != null);
        this.store = isStore;
        this.fncache = isFncache;
        this.dotencode = isDotencode;
        this.dirPathRewrite = new EncodeDirPathHelper();
        this.csEncoder = fsEncoding.newEncoder();
        this.byteEncodingBuf = ByteBuffer.allocate(Math.round(this.csEncoder.maxBytesPerChar()) + 1);
        this.charEncodingBuf = CharBuffer.allocate(1);
    }

    @Override
    public CharSequence rewrite(CharSequence p) {
        CharSequence path = this.dirPathRewrite.rewrite(p);
        StringBuilder sb = new StringBuilder(path.length() << 1);
        if (this.store || this.fncache) {
            int i = 0;
            while (i < path.length()) {
                char ch = path.charAt(i);
                if (ch >= 'a' && ch <= 'z') {
                    sb.append(ch);
                } else if (ch >= 'A' && ch <= 'Z') {
                    sb.append('_');
                    sb.append(Character.toLowerCase(ch));
                } else if ("\\:*?\"<>|".indexOf(ch) != -1) {
                    sb.append(this.toHexByte(ch));
                } else if (ch >= '~' && ch <= '\u00ff' || ch < ' ') {
                    sb.append(this.toHexByte(ch));
                } else if (ch == '_') {
                    sb.append('_');
                    sb.append('_');
                } else if (ch < '~' || !this.csEncoder.canEncode(ch)) {
                    sb.append(ch);
                } else {
                    this.appendEncoded(sb, ch);
                }
                ++i;
            }
            if (this.fncache) {
                this.encodeWindowsDeviceNames(sb);
            }
        }
        if (this.fncache && sb.length() + STR_DATA.length() + ".i".length() > 120) {
            String digest = new DigestHelper().sha1(STR_DATA, path, ".i").asHexString();
            sb = new StringBuilder(120);
            int i = 0;
            while (i < path.length()) {
                char ch = path.charAt(i);
                if (ch >= 'a' && ch <= 'z') {
                    sb.append(ch);
                } else if (ch >= 'A' && ch <= 'Z') {
                    sb.append((char)(ch | 0x20));
                } else if ("\\:*?\"<>|".indexOf(ch) != -1) {
                    sb.append(this.toHexByte(ch));
                } else if (ch >= '~' && ch <= '\u00ff' || ch < ' ') {
                    sb.append(this.toHexByte(ch));
                } else if (ch < '~' || !this.csEncoder.canEncode(ch)) {
                    sb.append(ch);
                } else {
                    this.appendEncoded(sb, ch);
                }
                ++i;
            }
            this.encodeWindowsDeviceNames(sb);
            int fnameStart = sb.lastIndexOf("/");
            StringBuilder completeHashName = new StringBuilder(120);
            completeHashName.append(STR_STORE);
            completeHashName.append(STR_DH);
            if (fnameStart == -1) {
                sb.setLength(80 - STR_DH.length() - ".i".length());
                completeHashName.append((CharSequence)sb);
            } else {
                int i2;
                StringBuilder sb2 = new StringBuilder(120);
                int x = 0;
                do {
                    i2 = sb.indexOf("/", x);
                    int sb2Len = sb2.length();
                    if (i2 - x <= 8) {
                        sb2.append(sb, x, i2 + 1);
                    } else {
                        sb2.append(sb, x, x + 8);
                        int last = sb2.length() - 1;
                        char lastChar = sb2.charAt(last);
                        assert (lastChar == sb.charAt(x + 8 - 1));
                        if (lastChar == '.' || lastChar == ' ') {
                            sb2.setCharAt(last, '_');
                        }
                        sb2.append('/');
                    }
                    if (sb2.length() - 1 <= 68) continue;
                    sb2.setLength(sb2Len);
                    break;
                } while ((x = i2 + 1) < fnameStart);
                assert (sb2.charAt(sb2.length() - 1) == '/');
                int left = 120 - sb2.length() - 40 - STR_DH.length() - ".i".length();
                assert (left >= 0);
                if (++fnameStart + left > sb.length()) {
                    sb2.append(sb, fnameStart, sb.length());
                    int stillAvailable = fnameStart + left - sb.length();
                    sb2.append(".i", 0, stillAvailable > 2 ? 2 : stillAvailable);
                } else {
                    sb2.append(sb, fnameStart, fnameStart + left);
                }
                completeHashName.append((CharSequence)sb2);
            }
            completeHashName.append(digest);
            sb = completeHashName;
        } else if (this.store) {
            sb.insert(0, "store/data/");
        }
        sb.append(".i");
        return sb.toString();
    }

    private void encodeWindowsDeviceNames(StringBuilder sb) {
        int i;
        int x = 0;
        TreeSet<String> windowsReservedFilenames = new TreeSet<String>();
        windowsReservedFilenames.addAll(Arrays.asList("con prn aux nul com1 com2 com3 com4 com5 com6 com7 com8 com9 lpt1 lpt2 lpt3 lpt4 lpt5 lpt6 lpt7 lpt8 lpt9".split(" ")));
        do {
            if ((i = sb.indexOf("/", x)) == -1) {
                i = sb.length();
            }
            if (i - x >= 3) {
                boolean found = false;
                if (i - x == 3 || i - x == 4) {
                    found = windowsReservedFilenames.contains(sb.subSequence(x, i));
                } else if (sb.charAt(x + 3) == '.') {
                    found = windowsReservedFilenames.contains(sb.subSequence(x, x + 3));
                } else if (i - x > 4 && sb.charAt(x + 4) == '.') {
                    found = windowsReservedFilenames.contains(sb.subSequence(x, x + 4));
                }
                if (found) {
                    StoragePathHelper.replace(sb, x + 2, this.toHexByte(sb.charAt(x + 2)));
                    i += 2;
                }
            }
            if (!this.dotencode || sb.charAt(x) != '.' && sb.charAt(x) != ' ') continue;
            char dotOrSpace = sb.charAt(x);
            StoragePathHelper.replace(sb, x, this.toHexByte(dotOrSpace));
            i += 2;
        } while ((x = i + 1) < sb.length());
    }

    private void appendEncoded(StringBuilder sb, char ch) {
        this.charEncodingBuf.clear();
        this.byteEncodingBuf.clear();
        this.charEncodingBuf.put(ch).flip();
        this.csEncoder.encode(this.charEncodingBuf, this.byteEncodingBuf, false);
        this.byteEncodingBuf.flip();
        while (this.byteEncodingBuf.hasRemaining()) {
            sb.append(this.toHexByte(this.byteEncodingBuf.get()));
        }
    }

    private static void replace(StringBuilder sb, int index, char[] with) {
        sb.setCharAt(index, with[0]);
        sb.insert(index + 1, with, 1, with.length - 1);
    }

    private char[] toHexByte(int ch) {
        this.hexEncodedByte[1] = "0123456789abcdef".charAt((ch & 0xF0) >>> 4);
        this.hexEncodedByte[2] = "0123456789abcdef".charAt(ch & 0xF);
        return this.hexEncodedByte;
    }
}

