/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.PrintStream;
import org.tmatesoft.hg.util.LogFacility;

public class StreamLogFacility
implements LogFacility {
    private final boolean isDebug;
    private final LogFacility.Severity severity;
    protected final boolean timestamp;
    protected final PrintStream outStream;

    public StreamLogFacility(LogFacility.Severity level, boolean needTimestamp, PrintStream out) {
        assert (level != null);
        this.severity = level;
        this.isDebug = level == LogFacility.Severity.Debug;
        this.timestamp = needTimestamp;
        this.outStream = out;
    }

    @Override
    public boolean isDebug() {
        return this.isDebug;
    }

    @Override
    public LogFacility.Severity getLevel() {
        return this.severity;
    }

    @Override
    public void dump(Class<?> src, LogFacility.Severity severity, String format, Object ... args) {
        if (severity.ordinal() >= this.getLevel().ordinal()) {
            this.printf(severity, src, format, args);
        }
    }

    @Override
    public void dump(Class<?> src, LogFacility.Severity severity, Throwable th, String message) {
        if (severity.ordinal() >= this.getLevel().ordinal()) {
            this.printf(severity, src, th, message);
        }
    }

    protected void printf(LogFacility.Severity level, Class<?> src, String format, Object ... args) {
        String msg = String.format(format, args);
        if (this.timestamp) {
            this.outStream.printf(this.isDebug ? "%tT.%1$tL " : "%tT ", System.currentTimeMillis());
        }
        if (this.isDebug) {
            String cn = src.getName();
            if (cn.startsWith("org.tmatesoft.hg.")) {
                cn = "oth." + cn.substring("org.tmatesoft.hg.".length());
            }
            this.outStream.printf("(%s) ", cn);
        }
        this.outStream.printf("%s: %s", level.toString().toUpperCase(), msg);
        if (format.length() == 0 || format.charAt(format.length() - 1) != '\n') {
            this.outStream.println();
        }
    }

    protected void printf(LogFacility.Severity level, Class<?> src, Throwable th, String msg) {
        if (msg != null || this.timestamp || this.isDebug || th == null) {
            this.printf(level, src, msg == null ? "" : msg, null);
        }
        if (th != null) {
            if (this.getLevel().ordinal() <= LogFacility.Severity.Info.ordinal()) {
                th.printStackTrace(this.outStream);
            } else {
                this.outStream.printf("%s: %s\n", th.getClass().getName(), th.getMessage());
            }
        }
    }

    public static LogFacility newDefault() {
        return new StreamLogFacility(LogFacility.Severity.Debug, true, System.out);
    }
}

