/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgSubrepoLocation;
import org.tmatesoft.hg.util.Path;

public class SubrepoManager {
    private final HgRepository repo;
    private List<HgSubrepoLocation> subRepos;

    public SubrepoManager(HgRepository hgRepo) {
        assert (hgRepo != null);
        this.repo = hgRepo;
    }

    private List<HgSubrepoLocation> readActualState() throws HgInvalidControlFileException {
        Map<String, String> state;
        File hgsubFile = new File(this.repo.getWorkingDir(), ".hgsub");
        if (!hgsubFile.canRead()) {
            return Collections.emptyList();
        }
        File hgstateFile = null;
        try {
            hgstateFile = new File(this.repo.getWorkingDir(), ".hgsubstate");
            state = hgstateFile.canRead() ? this.readState(new BufferedReader(new FileReader(hgstateFile))) : Collections.emptyMap();
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Subrepo state read failed", ex, hgstateFile);
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(hgsubFile));
            return this.readConfig(br, state);
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Subrepo state read failed", ex, hgsubFile);
        }
    }

    private List<HgSubrepoLocation> readConfig(BufferedReader br, Map<String, String> substate) throws IOException {
        try {
            String line;
            LinkedList<HgSubrepoLocation> res = new LinkedList<HgSubrepoLocation>();
            HgInternals hgRepoInternal = new HgInternals(this.repo);
            Path.Source pathFactory = this.repo.getSessionContext().getPathFactory();
            while ((line = br.readLine()) != null) {
                int sep = line.indexOf(61);
                if (sep == -1) continue;
                String key = line.substring(0, sep).trim();
                String value = line.substring(sep + 1).trim();
                if (key.length() == 0 || value.length() == 0) continue;
                HgSubrepoLocation.Kind kind = HgSubrepoLocation.Kind.Hg;
                int kindEnd = value.indexOf(93, 1);
                if (value.charAt(0) == '[' && kindEnd != -1) {
                    String kindStr = value.substring(1, kindEnd);
                    value = value.substring(kindEnd + 1);
                    if ("svn".equals(kindStr)) {
                        kind = HgSubrepoLocation.Kind.SVN;
                    } else if ("git".equals(kindStr)) {
                        kind = HgSubrepoLocation.Kind.Git;
                    }
                }
                Path p = pathFactory.path(key.charAt(key.length() - 1) == '/' ? key : String.valueOf(key) + '/');
                String revValue = substate.get(key);
                HgSubrepoLocation loc = hgRepoInternal.newSubrepo(p, value, kind, revValue == null ? null : Nodeid.fromAscii(revValue));
                res.add(loc);
            }
            List<HgSubrepoLocation> list = Arrays.asList(res.toArray(new HgSubrepoLocation[res.size()]));
            return list;
        }
        finally {
            br.close();
        }
    }

    private Map<String, String> readState(BufferedReader br) throws IOException {
        HashMap<String, String> rv = new HashMap<String, String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int sep = line.trim().indexOf(32);
                if (sep == -1) continue;
                rv.put(line.substring(sep + 1).trim(), line.substring(0, sep).trim());
            }
        }
        finally {
            br.close();
        }
        return rv;
    }

    public void read() throws HgInvalidControlFileException {
        this.subRepos = this.readActualState();
    }

    public List<HgSubrepoLocation> all() {
        assert (this.subRepos != null);
        return this.subRepos;
    }
}

