/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.IOException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.repo.HgInvalidStateException;

public abstract class Transaction {
    public abstract File prepare(File var1) throws HgIOException;

    public abstract File prepare(File var1, File var2) throws HgIOException;

    public abstract void done(File var1) throws HgIOException;

    public abstract void failure(File var1, IOException var2);

    public abstract void commit() throws HgIOException;

    public abstract void rollback() throws HgIOException;

    public static interface Factory {
        public Transaction create(SessionContext.Source var1);
    }

    public static class NoRollback
    extends Transaction {
        @Override
        public File prepare(File f) throws HgIOException {
            return f;
        }

        @Override
        public File prepare(File origin, File backup) throws HgIOException {
            return origin;
        }

        @Override
        public void done(File f) throws HgIOException {
        }

        @Override
        public void failure(File f, IOException ex) {
        }

        @Override
        public void commit() throws HgIOException {
        }

        @Override
        public void rollback() throws HgIOException {
            throw new HgInvalidStateException("This transaction doesn't support rollback");
        }
    }
}

