/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelledException;

public class WorkingCopyContent
implements DataSerializer.DataSource {
    private final HgDataFile file;

    public WorkingCopyContent(HgDataFile dataFile) {
        this.file = dataFile;
        if (!dataFile.exists()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void serialize(final DataSerializer out) throws HgIOException, HgRuntimeException {
        final HgIOException[] failure = new HgIOException[1];
        try {
            this.file.workingCopy(new ByteChannel(){

                @Override
                public int write(ByteBuffer buffer) throws IOException {
                    try {
                        if (buffer.hasArray()) {
                            out.write(buffer.array(), buffer.position(), buffer.remaining());
                        }
                        int rv = buffer.remaining();
                        buffer.position(buffer.limit());
                        return rv;
                    }
                    catch (HgIOException ex) {
                        failure[0] = ex;
                        IOException e = new IOException();
                        ex.initCause(ex);
                        throw e;
                    }
                }
            });
        }
        catch (HgInvalidFileException ex) {
            if (failure[0] != null) {
                throw failure[0];
            }
            throw new HgIOException("Write failure", ex, new File(this.file.getRepo().getWorkingDir(), this.file.getPath().toString()));
        }
        catch (CancelledException cancelledException) {
            throw new HgInvalidStateException("Our channel doesn't cancel here");
        }
    }

    @Override
    public int serializeLength() throws HgRuntimeException {
        return this.file.getLength(-2);
    }
}

