/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.FileSystemHelper;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;

public class WorkingDirFileWriter
implements ByteChannel {
    private final Internals hgRepo;
    private final boolean execCap;
    private final boolean symlinkCap;
    private final FileSystemHelper fileFlagsHelper;
    private File dest;
    private FileChannel destChannel;
    private int totalBytesWritten;
    private ByteArrayChannel linkChannel;
    private int fmode;

    public WorkingDirFileWriter(Internals internalRepo) {
        this.hgRepo = internalRepo;
        this.execCap = Internals.checkSupportsExecutables(internalRepo.getRepo().getWorkingDir());
        this.symlinkCap = Internals.checkSupportsSymlinks(internalRepo.getRepo().getWorkingDir());
        this.fileFlagsHelper = this.symlinkCap || this.execCap ? new FileSystemHelper(internalRepo.getSessionContext()) : null;
    }

    public void processFile(HgDataFile df, int fileRevIndex, HgManifest.Flags flags) throws IOException, HgRuntimeException {
        block17: {
            try {
                try {
                    this.prepare(df.getPath());
                    if (flags != HgManifest.Flags.Link) {
                        this.destChannel = new FileOutputStream(this.dest).getChannel();
                    } else {
                        this.linkChannel = new ByteArrayChannel();
                    }
                    df.contentWithFilters(fileRevIndex, this);
                }
                catch (CancelledException ex) {
                    this.hgRepo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, "Our impl doesn't throw cancellation");
                    if (flags != HgManifest.Flags.Link) {
                        this.destChannel.close();
                        this.destChannel = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (flags != HgManifest.Flags.Link) {
                    this.destChannel.close();
                    this.destChannel = null;
                }
                throw throwable;
            }
            if (flags != HgManifest.Flags.Link) {
                this.destChannel.close();
                this.destChannel = null;
            }
        }
        if (this.linkChannel != null && this.symlinkCap) {
            assert (flags == HgManifest.Flags.Link);
            this.fileFlagsHelper.createSymlink(this.dest.getParentFile(), this.dest.getName(), this.linkChannel.toArray());
        } else if (flags == HgManifest.Flags.Exec && this.execCap) {
            this.fileFlagsHelper.setExecutableBit(this.dest.getParentFile(), this.dest.getName());
        }
        this.fmode = flags.fsMode();
        if (this.fileFlagsHelper != null) {
            try {
                this.fmode = this.fileFlagsHelper.getFileMode(this.dest, this.fmode);
            }
            catch (IOException ex) {
                this.hgRepo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, "Failed get file access rights");
            }
        }
    }

    public void prepare(Path fname) throws IOException {
        String fpath = fname.toString();
        this.dest = new File(this.hgRepo.getRepo().getWorkingDir(), fpath);
        if (fpath.indexOf(47) != -1) {
            this.dest.getParentFile().mkdirs();
        }
        this.destChannel = null;
        this.linkChannel = null;
        this.totalBytesWritten = 0;
        this.fmode = 0;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException, CancelledException {
        int written = this.linkChannel != null ? this.linkChannel.write(buffer) : this.destChannel.write(buffer);
        this.totalBytesWritten += written;
        return written;
    }

    public File getDestinationFile() {
        return this.dest;
    }

    public int bytesWritten() {
        return this.totalBytesWritten;
    }

    public int fmode() {
        return this.fmode;
    }

    public int mtime() {
        return (int)(this.dest.lastModified() / 1000L);
    }
}

