/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.diff;

import java.util.ArrayList;
import org.tmatesoft.hg.internal.DiffHelper;
import org.tmatesoft.hg.internal.IntSliceSeq;
import org.tmatesoft.hg.internal.IntTuple;

public class DiffRangeMap
extends DiffHelper.DeltaInspector<DiffHelper.ChunkSequence<?>> {
    private final IntSliceSeq ranges = new IntSliceSeq(5);

    public DiffRangeMap fill(DiffHelper<?> dh) {
        DiffRangeMap i = this;
        dh.findMatchingBlocks(i);
        return this;
    }

    @Override
    protected void added(int s1InsertPoint, int s2From, int s2To) {
        this.ranges.add(s1InsertPoint, s1InsertPoint, s2From, s2To, 43);
    }

    @Override
    protected void changed(int s1From, int s1To, int s2From, int s2To) {
        this.ranges.add(s1From, s1To, s2From, s2To, 42);
    }

    @Override
    protected void deleted(int s2DeletePoint, int s1From, int s1To) {
        this.ranges.add(s1From, s1To, s2DeletePoint, s2DeletePoint, 45);
    }

    @Override
    protected void unchanged(int s1From, int s2From, int length) {
        this.ranges.add(s1From, s1From + length, s2From, s2From + length, 61);
    }

    public Iterable<RangePair> findInSource(int sourceStart, int sourceEnd) {
        ArrayList<RangePair> rv = new ArrayList<RangePair>(4);
        for (IntTuple t : this.ranges) {
            int srcRangeStart = t.at(0);
            int srcRangeEnd = t.at(1);
            if (srcRangeEnd <= sourceStart) continue;
            if (srcRangeStart >= sourceEnd) break;
            rv.add(new RangePair(srcRangeStart, srcRangeEnd, t.at(2), t.at(3)));
        }
        return rv;
    }

    public Iterable<RangePair> insertions() {
        return this.rangesOfKind(43);
    }

    public Iterable<RangePair> same() {
        return this.rangesOfKind(61);
    }

    private Iterable<RangePair> rangesOfKind(int kind) {
        ArrayList<RangePair> rv = new ArrayList<RangePair>(4);
        for (IntTuple t : this.ranges) {
            if (t.at(4) != kind) continue;
            rv.add(new RangePair(t.at(0), t.at(1), t.at(2), t.at(3)));
        }
        return rv;
    }

    public static final class RangePair {
        private final int s1Start;
        private final int s1End;
        private final int s2Start;
        private final int s2End;

        public RangePair(int s1Start, int s1End, int s2Start, int s2End) {
            this.s1Start = s1Start;
            this.s1End = s1End;
            this.s2Start = s2Start;
            this.s2End = s2End;
        }

        public int start1() {
            return this.s1Start;
        }

        public int end1() {
            return this.s1End;
        }

        public int length1() {
            return this.s1End - this.s1Start;
        }

        public int start2() {
            return this.s2Start;
        }

        public int end2() {
            return this.s2End;
        }

        public int length2() {
            return this.s2End - this.s2Start;
        }

        public String toString() {
            return String.format("[%d..%d)->[%d..%d)", this.s1Start, this.s1End, this.s2Start, this.s2End);
        }
    }
}

