/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.auth.HgAuthMethod;
import org.tmatesoft.hg.auth.HgAuthenticator;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.util.LogFacility;

public class BasicAuthenticator
implements HgAuthenticator {
    private final LogFacility log;

    public BasicAuthenticator(LogFacility logFacility) {
        this.log = logFacility;
    }

    @Override
    public void authenticate(HgRemoteRepository.RemoteDescriptor rd, HgAuthMethod authMethod) throws HgAuthFailedException {
        if (authMethod.supportsPublicKey() && this.tryPlatformDefaultKeyLocations(rd, authMethod)) {
            return;
        }
        authMethod.noCredentials();
    }

    protected boolean tryPlatformDefaultKeyLocations(HgRemoteRepository.RemoteDescriptor rd, HgAuthMethod authMethod) {
        String userHome = System.getProperty("user.home");
        File sshDir = new File(userHome, ".ssh");
        if (!sshDir.isDirectory()) {
            return false;
        }
        String username = System.getProperty("user.name");
        String[] stringArray = new String[]{"id_rsa", "id_dsa", "identity"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            File id = new File(sshDir, fn);
            if (id.canRead()) {
                try {
                    FileInputStream fis = new FileInputStream(id);
                    authMethod.withPublicKey(username, fis, null);
                    fis.close();
                    return true;
                }
                catch (IOException ex) {
                    this.log.dump(this.getClass(), LogFacility.Severity.Warn, ex, String.format("Attempting default ssh identity key locations: %s", id));
                }
                catch (HgAuthFailedException ex) {
                    this.log.dump(this.getClass(), LogFacility.Severity.Debug, ex, String.format("Attempting default ssh identity key locations: %s", id));
                }
            }
            ++n2;
        }
        return false;
    }
}

