/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.remote.Connector;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public abstract class ConnectorBase
implements Connector {
    protected URI uri;

    protected ConnectorBase() {
    }

    protected void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public void init(HgRemoteRepository.RemoteDescriptor remote, SessionContext sessionContext, Object globalConfig) throws HgRuntimeException {
        this.setURI(remote.getURI());
    }

    @Override
    public String getServerLocation() {
        if (this.uri == null) {
            return "";
        }
        if (this.uri.getUserInfo() == null) {
            return this.uri.toString();
        }
        if (this.uri.getPort() != -1) {
            return String.format("%s://%s:%d%s", this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath());
        }
        return String.format("%s://%s%s", this.uri.getScheme(), this.uri.getHost(), this.uri.getPath());
    }

    @Override
    public void connect() throws HgAuthFailedException, HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public void disconnect() throws HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public void sessionBegin() throws HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public void sessionEnd() throws HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public String getCapabilities() throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream heads() throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream between(Collection<HgRemoteRepository.Range> ranges) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream branches(List<Nodeid> nodes) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream changegroup(List<Nodeid> roots) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public OutputStream unbundle(long outputLen, List<Nodeid> remoteHeads) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream pushkey(String opName, String namespace, String key, String oldValue, String newValue) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }

    @Override
    public InputStream listkeys(String namespace, String actionName) throws HgRemoteConnectionException, HgRuntimeException {
        return null;
    }
}

